/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryIsEquivalentTranslator
extends DIGQueryTranslator {
    protected String m_predicate;
    protected Node m_qSubject;
    protected Node m_qObject;

    public DIGQueryIsEquivalentTranslator(String predicate) {
        super(null, null, null);
        this.m_predicate = predicate;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        return this.translatePattern(pattern, da, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        this.m_qSubject = pattern.getSubject();
        this.m_qObject = pattern.getObject();
        if (this.m_qSubject.isBlank() && this.m_qObject.isBlank()) {
            LogFactory.getLog(this.getClass()).warn((Object)"DIG 1.1 cannot handle isConcept query with two expressions");
            return null;
        }
        if (this.m_qObject.isBlank()) {
            Node temp = this.m_qSubject;
            this.m_qSubject = this.m_qObject;
            this.m_qObject = temp;
        }
        Node p = pattern.getPredicate();
        if (!this.m_qObject.isBlank() && (p.getURI().equals(da.getOntLanguage().UNION_OF().getURI()) || p.getURI().equals(da.getOntLanguage().INTERSECTION_OF().getURI()) || p.getURI().equals(da.getOntLanguage().COMPLEMENT_OF().getURI())) || p.getURI().equals(da.getOntLanguage().ONE_OF().getURI())) {
            if (premises == null) {
                LogFactory.getLog(this.getClass()).warn((Object)"Cannot add comprehension axiom bNode for query because premises model is null");
            } else {
                Resource comp = premises.createResource(da.getOntLanguage().CLASS());
                premises.add(comp, premises.getProperty(p.getURI()), premises.getRDFNode(this.m_qSubject));
                this.m_qSubject = comp.asNode();
            }
        }
        Element equivalents = da.createQueryElement(query2, "equivalents");
        da.addClassDescription(equivalents, this.m_qSubject, premises);
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.conceptSetNameCheck(response, da, this.m_qObject, query2.asTriple());
    }

    public boolean checkTriple(TriplePattern pattern, DIGAdapter da, Model premises) {
        Node object = pattern.getObject();
        Node subject = pattern.getSubject();
        Node pred = pattern.getPredicate();
        boolean pass = subject.isConcrete() && object.isConcrete() && pred.isConcrete();
        pass = pass && ((object.isBlank() || da.isConcept(object, premises)) && subject.isBlank() || da.isConcept(subject, premises) && (!subject.isBlank() || !object.isBlank()));
        pass = pass && (pred.getURI().equals(this.m_predicate) || pred.getURI().equals(da.getOntLanguage().UNION_OF().getURI()) || pred.getURI().equals(da.getOntLanguage().INTERSECTION_OF().getURI()) || pred.getURI().equals(da.getOntLanguage().COMPLEMENT_OF().getURI()) || pred.getURI().equals(da.getOntLanguage().ONE_OF().getURI()));
        return pass;
    }

    public boolean trigger(TriplePattern pattern, DIGAdapter da, Model premises) {
        return super.trigger(pattern, da, premises);
    }
}

