/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQuerySubsumesTranslator
extends DIGQueryTranslator {
    public DIGQuerySubsumesTranslator(String predicate) {
        super(null, predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element subsumes = da.createQueryElement(query2, "subsumes");
        da.addClassDescription(subsumes, pattern.getObject());
        da.addClassDescription(subsumes, pattern.getSubject());
        return query2;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element subsumes = da.createQueryElement(query2, "subsumes");
        if (pattern.getObject().isBlank()) {
            da.addClassDescription(subsumes, pattern.getObject(), premises);
        } else {
            da.addClassDescription(subsumes, pattern.getObject());
        }
        if (pattern.getSubject().isBlank()) {
            da.addClassDescription(subsumes, pattern.getSubject(), premises);
        } else {
            da.addClassDescription(subsumes, pattern.getSubject());
        }
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.isTrue(response) ? new SingletonIterator(query2.asTriple()) : NullIterator.instance;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        boolean isSubjectConcept = da.isConcept(subject, premises);
        return isSubjectConcept;
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        boolean isObjectConcept = da.isConcept(object, premises);
        return isObjectConcept;
    }
}

