/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import java.util.ArrayList;
import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import mx.com.hp.hpl.jena.reasoner.dig.DIGConnection;
import mx.com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import mx.com.hp.hpl.jena.reasoner.dig.TripleObjectFiller;
import mx.com.hp.hpl.jena.reasoner.dig.TripleSubjectFiller;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Filter;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.SingletonIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.util.xml.SimpleXMLPath;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DIGQueryTranslator {
    public static final String ALL = "*";
    private Node m_subject;
    private Node m_object;
    private Node m_pred;

    public DIGQueryTranslator(String subject, String predicate, String object) {
        this.m_subject = this.mapNode(subject);
        this.m_pred = this.mapNode(predicate);
        this.m_object = this.mapNode(object);
    }

    public ExtendedIterator find(TriplePattern pattern, DIGAdapter da) {
        Document response;
        boolean warn;
        DIGConnection dc = da.getConnection();
        Document query2 = this.translatePattern(pattern, da);
        if (query2 == null) {
            LogFactory.getLog(this.getClass()).warn((Object)("Could not find pattern translator for nested DIG query " + pattern));
        }
        if (warn = dc.warningCheck(response = da.getConnection().sendDigVerb(query2, da.getProfile()))) {
            Iterator i = dc.getWarnings();
            while (i.hasNext()) {
                LogFactory.getLog(this.getClass()).warn(i.next());
            }
        }
        return this.translateResponse(response, pattern, da);
    }

    public ExtendedIterator find(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query2 = this.translatePattern(pattern, da, premises);
        if (query2 == null) {
            LogFactory.getLog(this.getClass()).warn((Object)("Could not find pattern translator for nested DIG query " + pattern));
            return NullIterator.instance;
        }
        Document response = da.getConnection().sendDigVerb(query2, da.getProfile());
        boolean warn = dc.warningCheck(response);
        if (warn) {
            Iterator i = dc.getWarnings();
            while (i.hasNext()) {
                LogFactory.getLog(this.getClass()).warn(i.next());
            }
        }
        return this.translateResponse(response, pattern, da);
    }

    public boolean trigger(TriplePattern pattern, DIGAdapter da, Model premises) {
        return this.trigger(this.m_subject, pattern.getSubject(), premises) && this.trigger(this.m_object, pattern.getObject(), premises) && this.trigger(this.m_pred, pattern.getPredicate(), premises) && this.checkTriple(pattern, da, premises);
    }

    public boolean checkTriple(TriplePattern pattern, DIGAdapter da, Model premises) {
        return this.checkSubject(pattern.getSubject(), da, premises) && this.checkObject(pattern.getObject(), da, premises) && this.checkPredicate(pattern.getPredicate(), da, premises);
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return true;
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return true;
    }

    public boolean checkPredicate(Node pred, DIGAdapter da, Model premises) {
        return true;
    }

    public abstract Document translatePattern(TriplePattern var1, DIGAdapter var2);

    public abstract Document translatePattern(TriplePattern var1, DIGAdapter var2, Model var3);

    public final ExtendedIterator translateResponse(Document response, TriplePattern query2, DIGAdapter da) {
        ExtendedIterator i = this.translateResponseHook(response, query2, da);
        Filter f = this.getResultsTripleFilter(query2);
        return f == null ? i : i.filterKeep(f);
    }

    protected abstract ExtendedIterator translateResponseHook(Document var1, TriplePattern var2, DIGAdapter var3);

    protected Node mapNode(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.equals(ALL) ? Node_RuleVariable.WILD : Node.createURI(uri);
    }

    protected boolean trigger(Node lhs, Node rhs, Model premises) {
        return lhs == null || lhs.equals(rhs);
    }

    protected boolean isTrue(Document response) {
        return new SimpleXMLPath(true).appendElementPath("true").getAll(response).hasNext();
    }

    protected boolean isFalse(Document response) {
        return new SimpleXMLPath(true).appendElementPath("false").getAll(response).hasNext();
    }

    protected ExtendedIterator translateConceptSetResponse(Document response, TriplePattern query2, boolean object, DIGAdapter da) {
        return this.translateNameSetResponse(response, query2, object, new String[]{"conceptSet", "synonyms", "catom"}).andThen(this.translateSpecialConcepts(response, da, object ? query2.getSubject() : query2.getObject(), query2.getPredicate(), object));
    }

    protected ExtendedIterator translateRoleSetResponse(Document response, TriplePattern query2, boolean object) {
        return this.translateNameSetResponse(response, query2, object, new String[]{"roleSet", "synonyms", "ratom"});
    }

    protected ExtendedIterator translateIndividualSetResponse(Document response, TriplePattern query2, boolean object) {
        return this.translateNameSetResponse(response, query2, object, new String[]{"individualSet", "individual"});
    }

    protected ExtendedIterator translateNameSetResponse(Document response, TriplePattern query2, boolean object, String[] path) {
        SimpleXMLPath p = new SimpleXMLPath(true);
        for (int i = 0; i < path.length; ++i) {
            p.appendElementPath(path[i]);
        }
        p.appendAttrPath("name");
        ExtendedIterator iNodes = p.getAll(response).mapWith(new DIGValueToNodeMapper());
        if (object) {
            return iNodes.mapWith(new TripleObjectFiller(query2.getSubject(), query2.getPredicate()));
        }
        return iNodes.mapWith(new TripleSubjectFiller(query2.getPredicate(), query2.getObject()));
    }

    protected ExtendedIterator conceptSetNameCheck(Document response, DIGAdapter da, Node node, Triple result) {
        ExtendedIterator catoms = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath(ALL).getAll(response);
        String oName = da.getNodeID(node);
        boolean seekingTop = oName.equals(da.getOntLanguage().THING().getURI());
        boolean seekingBottom = oName.equals(da.getOntLanguage().NOTHING().getURI());
        boolean found = false;
        while (!found && catoms.hasNext()) {
            Element name = (Element)catoms.next();
            found = seekingTop && name.getNodeName().equals("top") || seekingBottom && name.getNodeName().equals("bottom") || name.getAttribute("name").equals(oName);
        }
        return found ? new SingletonIterator(result) : NullIterator.instance;
    }

    protected ExtendedIterator translateSpecialConcepts(Document response, DIGAdapter da, Node ref, Node pred, boolean refSubject) {
        Node n;
        SimpleXMLPath topPath = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath("top");
        SimpleXMLPath bottomPath = new SimpleXMLPath(true).appendElementPath("conceptSet").appendElementPath("synonyms").appendElementPath("bottom");
        ArrayList<Triple> specials = new ArrayList<Triple>();
        if (topPath.getAll(response).hasNext()) {
            n = da.getOntLanguage().THING().asNode();
            specials.add(refSubject ? new Triple(ref, pred, n) : new Triple(n, pred, ref));
        }
        if (bottomPath.getAll(response).hasNext()) {
            n = da.getOntLanguage().NOTHING().asNode();
            specials.add(refSubject ? new Triple(ref, pred, n) : new Triple(n, pred, ref));
        }
        return WrappedIterator.create(specials.iterator());
    }

    protected Filter getResultsTripleFilter(TriplePattern query2) {
        return null;
    }
}

