/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.dig;

import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import mx.com.hp.hpl.jena.util.ResourceUtils;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class DIGReasonerFactory
implements ReasonerFactory {
    public static final String URI = "http://jena.hpl.hp.com/2003/DIGReasoner";
    public static final String DEFAULT_OWL_AXIOMS = "file:etc/dig-owl-axioms.rdf";
    public static final String DEFAULT_DAML_AXIOMS = "file:etc/dig-daml-axioms.rdf";
    private static DIGReasonerFactory s_instance = new DIGReasonerFactory();
    private Model m_capabilities = null;

    private DIGReasonerFactory() {
    }

    public static DIGReasonerFactory theInstance() {
        return s_instance;
    }

    public Reasoner create(Resource configuration) {
        return new DIGReasoner(null, this, configuration);
    }

    public Reasoner createWithDAMLAxioms(Resource configuration) {
        return this.create(OWL.NAMESPACE, DEFAULT_DAML_AXIOMS, configuration);
    }

    public Reasoner createWithOWLAxioms(Resource configuration) {
        return this.create(OWL.NAMESPACE, DEFAULT_OWL_AXIOMS, configuration);
    }

    public DIGReasoner create(Resource language, String axiomsURL, Resource configuration) {
        Resource root;
        Model config = ModelFactory.createDefaultModel();
        if (configuration != null) {
            config.add(ResourceUtils.reachableClosure(configuration));
            root = (Resource)config.getRDFNode(configuration.asNode());
        } else {
            root = config.createResource();
        }
        if (axiomsURL != null && !root.hasProperty(ReasonerVocabulary.EXT_REASONER_AXIOMS)) {
            config.add(root, ReasonerVocabulary.EXT_REASONER_AXIOMS, config.getResource(axiomsURL));
        }
        if (language != null && !root.hasProperty(ReasonerVocabulary.EXT_REASONER_ONT_LANG)) {
            config.add(root, ReasonerVocabulary.EXT_REASONER_ONT_LANG, language);
        }
        return (DIGReasoner)this.create(root);
    }

    public Model getCapabilities() {
        if (this.m_capabilities == null) {
            this.m_capabilities = ModelFactory.createDefaultModel();
            Resource base = this.m_capabilities.createResource(this.getURI());
            base.addProperty(ReasonerVocabulary.nameP, "DIG external Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Adapter for external (i.e. non-Jena) DIG reasoner.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubPropertyOf).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.m_capabilities;
    }

    public String getURI() {
        return URI;
    }
}

