/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rdfsReasoner1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import mx.com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;

public class BaseFRule {
    protected TriplePattern head;
    protected TriplePattern[] body;

    public BaseFRule(TriplePattern head, TriplePattern[] body) {
        this.head = head;
        this.body = body;
    }

    public BaseFRule(String spec) {
        List patterns = BaseFRule.parseTripleSequence(spec);
        this.head = (TriplePattern)patterns.get(0);
        this.body = new TriplePattern[patterns.size() - 1];
        for (int i = 1; i < patterns.size(); ++i) {
            this.body[i - 1] = (TriplePattern)patterns.get(i);
        }
    }

    public void bindAndFire(Triple value, RDFSInfGraph reasoner) {
        if ((value.getPredicate().equals(TransitiveReasoner.subPropertyOf) || value.getPredicate().equals(TransitiveReasoner.subClassOf)) && value.getSubject().equals(value.getObject())) {
            return;
        }
        HashMap bindings = new HashMap();
        BaseFRule.matchNode(value.getSubject(), this.head.getSubject(), bindings);
        BaseFRule.matchNode(value.getPredicate(), this.head.getPredicate(), bindings);
        BaseFRule.matchNode(value.getObject(), this.head.getObject(), bindings);
        TriplePattern[] newBody = new TriplePattern[this.body.length];
        for (int i = 0; i < this.body.length; ++i) {
            newBody[i] = new TriplePattern(BaseFRule.instantiate(this.body[i].getSubject(), bindings), BaseFRule.instantiate(this.body[i].getPredicate(), bindings), BaseFRule.instantiate(this.body[i].getObject(), bindings));
        }
        this.fire(newBody, reasoner);
    }

    void fire(TriplePattern[] body, RDFSInfGraph reasoner) {
    }

    static void matchNode(Node valueNode, Node patternNode, Map bindings) {
        if (patternNode.isVariable()) {
            bindings.put(patternNode.getName(), valueNode);
        }
    }

    static Node instantiate(Node elt, Map bindings) {
        Node result;
        if (elt.isVariable() && (result = (Node)bindings.get(elt.getName())) != null) {
            return result;
        }
        return elt;
    }

    public static Triple parseTriple(String spec) {
        StringTokenizer tokenizer = new StringTokenizer(spec);
        try {
            Node s = BRWRule.parseNode(tokenizer.nextToken());
            Node p = BRWRule.parseNode(tokenizer.nextToken());
            Node o = BRWRule.parseNode(tokenizer.nextToken());
            return new Triple(s, p, o);
        }
        catch (NoSuchElementException e) {
            throw new ReasonerException("Illegal triple: " + spec);
        }
    }

    private static TriplePattern parseTriplePattern(StringTokenizer tokenizer) {
        try {
            Node s = BRWRule.parseNode(tokenizer.nextToken());
            Node p = BRWRule.parseNode(tokenizer.nextToken());
            Node o = BRWRule.parseNode(tokenizer.nextToken());
            return new TriplePattern(s, p, o);
        }
        catch (NoSuchElementException e) {
            throw new ReasonerException("Illegal triple in rule");
        }
    }

    public static List parseTripleSequence(String spec) {
        StringTokenizer tokenizer = new StringTokenizer(spec);
        ArrayList<TriplePattern> triples = new ArrayList<TriplePattern>();
        while (tokenizer.hasMoreElements()) {
            String sep;
            triples.add(BaseFRule.parseTriplePattern(tokenizer));
            if (!tokenizer.hasMoreElements() || (sep = tokenizer.nextToken()).equals("|") || sep.equals("->") || sep.equals("<-")) continue;
            throw new ReasonerException("Illegal FRUle spec: " + spec);
        }
        return triples;
    }

    public TriplePattern getHead() {
        return this.head;
    }
}

