/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys;

import java.util.List;
import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.IllegalParameterException;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class BasicForwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected InfGraph schemaGraph;
    protected boolean recordDerivations = false;
    protected boolean traceOn = false;
    protected Capabilities capabilities;

    public BasicForwardRuleReasoner(List rules) {
        this.rules = rules;
    }

    public BasicForwardRuleReasoner(List rules, ReasonerFactory factory) {
        this.rules = rules;
        this.factory = factory;
    }

    private BasicForwardRuleReasoner(List rules, InfGraph schemaGraph, ReasonerFactory factory) {
        this.rules = rules;
        this.schemaGraph = schemaGraph;
        this.factory = factory;
    }

    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model configSpec, Resource base) {
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root = caps.getResource(this.factory.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox);
        return new BasicForwardRuleReasoner(this.rules, graph, this.factory);
    }

    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox.getGraph());
        return new BasicForwardRuleReasoner(this.rules, graph, this.factory);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, this.schemaGraph);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    public List getRules() {
        return this.rules;
    }

    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public void setParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
        } else if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + parameter + " for rule-based reasoner");
        }
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

