/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.IllegalParameterException;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import mx.com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.RETERuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class GenericRuleReasoner
extends FBRuleReasoner {
    protected LPRuleStore bRuleStore;
    protected RuleMode mode = HYBRID;
    protected static final boolean cachePreload = true;
    protected boolean enableTGCCaching = false;
    protected boolean enableOWLTranslation = false;
    protected HashSet preprocessorHooks;
    public boolean filterFunctors = true;
    private static final OWLRuleTranslationHook owlTranslator = new OWLRuleTranslationHook();
    public static final RuleMode FORWARD = new RuleMode("forward");
    public static final RuleMode FORWARD_RETE = new RuleMode("forwardRETE");
    public static final RuleMode BACKWARD = new RuleMode("backward");
    public static final RuleMode HYBRID = new RuleMode("hybrid");

    public GenericRuleReasoner(List rules) {
        super(rules);
    }

    public GenericRuleReasoner(ReasonerFactory factory, Resource configuration) {
        super(factory);
        this.configuration = configuration;
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    public GenericRuleReasoner(List rules, ReasonerFactory factory) {
        super(rules, factory);
    }

    protected GenericRuleReasoner(List rules, Graph schemaGraph, ReasonerFactory factory, RuleMode mode) {
        this(rules, factory);
        this.schemaGraph = schemaGraph;
        this.mode = mode;
    }

    public void setMode(RuleMode mode) {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can't change mode of a reasoner bound to a schema");
        }
        this.mode = mode;
        this.preload = null;
        this.bRuleStore = null;
    }

    public void setRules(List rules) {
        super.setRules(rules);
    }

    public void setOWLTranslation(boolean enableOWLTranslation) {
        if (enableOWLTranslation && this.mode != HYBRID) {
            throw new ReasonerException("Can only enable OWL rule translation in HYBRID mode");
        }
        this.enableOWLTranslation = enableOWLTranslation;
        if (enableOWLTranslation) {
            this.addPreprocessingHook(owlTranslator);
        } else {
            this.removePreprocessingHook(owlTranslator);
        }
    }

    public void setTransitiveClosureCaching(boolean enableTGCCaching) {
        this.enableTGCCaching = enableTGCCaching;
    }

    public void setFunctorFiltering(boolean param) {
        this.filterFunctors = param;
    }

    public void addPreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new HashSet();
        }
        this.preprocessorHooks.add(hook);
    }

    public void removePreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks != null) {
            this.preprocessorHooks.remove(hook);
        }
    }

    protected boolean doSetResourceParameter(Property parameter, Resource value) {
        if (parameter.equals(JenaModelSpec.ruleSetURL)) {
            this.addRules(Rule.rulesFromURL(value.getURI()));
        } else if (parameter.equals(JenaModelSpec.ruleSet)) {
            StmtIterator that = value.listProperties(JenaModelSpec.ruleSetURL);
            while (that.hasNext()) {
                this.addRules(Rule.rulesFromURL(that.nextStatement().getResource().getURI()));
            }
            StmtIterator it = value.listProperties(JenaModelSpec.hasRule);
            while (it.hasNext()) {
                this.addRules(Rule.parseRules(it.nextStatement().getString()));
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPenableFunctorFiltering)) {
            this.filterFunctors = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPenableOWLTranslation)) {
            this.enableOWLTranslation = Util.convertBooleanPredicateArg(parameter, value);
            if (this.enableOWLTranslation) {
                this.addPreprocessingHook(owlTranslator);
                return true;
            } else {
                this.removePreprocessingHook(owlTranslator);
            }
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPenableTGCCaching)) {
            this.enableTGCCaching = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPruleMode)) {
            if (value.equals(GenericRuleReasoner.FORWARD.name)) {
                this.mode = FORWARD;
                return true;
            } else if (value.equals(GenericRuleReasoner.FORWARD_RETE.name)) {
                this.mode = FORWARD_RETE;
                return true;
            } else if (value.equals(GenericRuleReasoner.BACKWARD.name)) {
                this.mode = BACKWARD;
                return true;
            } else {
                if (!value.equals(GenericRuleReasoner.HYBRID.name)) throw new IllegalParameterException("PROPruleMode can only be 'forward'm 'forwardRETE', 'backward', 'hybrid', not " + value);
                this.mode = HYBRID;
            }
            return true;
        } else {
            if (!parameter.equals(ReasonerVocabulary.PROPruleSet)) return false;
            if (!(value instanceof String)) throw new IllegalParameterException("PROPruleSet value should be a URI string. Was a " + value.getClass());
            this.addRules(GenericRuleReasoner.loadRules((String)value));
        }
        return true;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to a GenericRuleReasoner");
        }
        Graph graph = null;
        if (this.mode == FORWARD) {
            graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox);
            ((InfGraph)graph).prepare();
        } else if (this.mode == FORWARD_RETE) {
            graph = new RETERuleInfGraph(this, this.rules, null, tbox);
            ((InfGraph)graph).prepare();
        } else if (this.mode == BACKWARD) {
            graph = tbox;
        } else {
            List ruleSet = this.rules;
            graph = new FBRuleInfGraph(this, ruleSet, this.getPreload(), tbox);
            if (this.enableTGCCaching) {
                ((FBRuleInfGraph)graph).setUseTGCCache();
            }
            ((FBRuleInfGraph)graph).prepare();
        }
        GenericRuleReasoner grr = new GenericRuleReasoner(this.rules, graph, this.factory, this.mode);
        grr.setDerivationLogging(this.recordDerivations);
        grr.setTraceOn(this.traceOn);
        grr.setTransitiveClosureCaching(this.enableTGCCaching);
        grr.setFunctorFiltering(this.filterFunctors);
        if (this.preprocessorHooks != null) {
            Iterator i = this.preprocessorHooks.iterator();
            while (i.hasNext()) {
                grr.addPreprocessingHook((RulePreprocessHook)i.next());
            }
        }
        return grr;
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        Graph schemaArg = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        BaseInfGraph graph = null;
        if (this.mode == FORWARD) {
            graph = new BasicForwardRuleInfGraph(this, this.rules, schemaArg);
            ((BasicForwardRuleInfGraph)graph).setTraceOn(this.traceOn);
        } else if (this.mode == FORWARD_RETE) {
            graph = new RETERuleInfGraph(this, this.rules, schemaArg);
            ((BasicForwardRuleInfGraph)graph).setTraceOn(this.traceOn);
        } else if (this.mode == BACKWARD) {
            graph = new LPBackwardRuleInfGraph(this, this.getBruleStore(), data, schemaArg);
            ((LPBackwardRuleInfGraph)graph).setTraceOn(this.traceOn);
        } else {
            List ruleSet = ((FBRuleInfGraph)schemaArg).getRules();
            FBRuleInfGraph fbgraph = new FBRuleInfGraph(this, ruleSet, schemaArg);
            graph = fbgraph;
            if (this.enableTGCCaching) {
                fbgraph.setUseTGCCache();
            }
            fbgraph.setTraceOn(this.traceOn);
            fbgraph.setFunctorFiltering(this.filterFunctors);
            if (this.preprocessorHooks != null) {
                Iterator i = this.preprocessorHooks.iterator();
                while (i.hasNext()) {
                    fbgraph.addPreprocessingHook((RulePreprocessHook)i.next());
                }
            }
        }
        graph.setDerivationLogging(this.recordDerivations);
        graph.rebind(data);
        return graph;
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null && this.mode == HYBRID) {
            if (this.mode == HYBRID) {
                this.preload = new FBRuleInfGraph(this, this.rules, null);
                if (this.enableTGCCaching) {
                    ((FBRuleInfGraph)this.preload).setUseTGCCache();
                }
            } else if (this.mode == FORWARD) {
                this.preload = new BasicForwardRuleInfGraph(this, this.rules, null);
            } else if (this.mode == FORWARD_RETE) {
                this.preload = new RETERuleInfGraph(this, this.rules, null);
            }
            this.preload.prepare();
        }
        return this.preload;
    }

    protected LPRuleStore getBruleStore() {
        if (this.bRuleStore == null) {
            this.bRuleStore = new LPRuleStore(this.rules);
        }
        return this.bRuleStore;
    }

    public static class RuleMode {
        String name;

        protected RuleMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

