/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys;

import java.util.List;
import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.IllegalParameterException;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class LPBackwardRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected LPRuleStore ruleStore;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected Capabilities capabilities;

    public LPBackwardRuleReasoner(List rules) {
        this.rules = rules;
        this.ruleStore = new LPRuleStore(rules);
    }

    public LPBackwardRuleReasoner(List rules, ReasonerFactory factory) {
        this.rules = rules;
        this.factory = factory;
        this.ruleStore = new LPRuleStore(rules);
    }

    protected LPBackwardRuleReasoner(LPBackwardRuleReasoner parent, Graph schemaGraph) {
        this.rules = parent.rules;
        this.ruleStore = parent.ruleStore;
        this.schemaGraph = schemaGraph;
        this.factory = parent.factory;
    }

    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model configSpec, Resource base) {
    }

    public synchronized void tablePredicate(Node predicate) {
        this.ruleStore.tablePredicate(predicate);
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root = caps.getResource(this.factory.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, tbox);
    }

    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return new LPBackwardRuleReasoner(this, tbox.getGraph());
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        LPBackwardRuleInfGraph graph = new LPBackwardRuleInfGraph(this, this.ruleStore, data, this.schemaGraph);
        graph.setDerivationLogging(this.recordDerivations);
        return graph;
    }

    public List getRules() {
        return this.rules;
    }

    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public void setParameter(Property parameter, Object value) {
        throw new IllegalParameterException(parameter.toString());
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

