/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.builtins;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Drop
extends BaseBuiltin {
    public String getName() {
        return "drop";
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        boolean ok = false;
        InfGraph inf = context.getGraph();
        Graph raw = inf.getRawGraph();
        Graph deductions = inf.getDeductionsGraph();
        for (int i = 0; i < length; ++i) {
            ClauseEntry clause;
            Node clauseN = this.getArg(i, args, context);
            if (Util.isNumeric(clauseN)) {
                int clauseIndex = Util.getIntValue(clauseN);
                clause = context.getRule().getBodyElement(clauseIndex);
                if (!(clause instanceof TriplePattern)) {
                    throw new BuiltinException(this, context, "illegal triple to remove non-triple clause");
                }
            } else {
                throw new BuiltinException(this, context, "illegal arg to remove (" + clauseN + "), must be an integer");
            }
            Triple t = context.getEnv().instantiate((TriplePattern)clause);
            raw.delete(t);
            deductions.delete(t);
        }
    }

    public boolean isMonotonic() {
        return false;
    }
}

