/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import mx.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;

public class BBRuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected BackwardRuleInfGraphI graph;

    public BBRuleContext(BackwardRuleInfGraphI graph) {
        this.graph = graph;
    }

    public boolean contains(Node s, Node p, Node o) {
        ClosableIterator i = this.find(s, p, o);
        boolean result = i.hasNext();
        i.close();
        return result;
    }

    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public ClosableIterator find(Node s, Node p, Node o) {
        return this.graph.findDataMatches(new TriplePattern(s, p, o));
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    public void add(Triple t) {
        this.graph.silentAdd(t);
    }

    public void remove(Triple t) {
        this.graph.delete(t);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.graph.getTemp(instance, prop, pclass);
    }
}

