/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.List;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.Generator;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.GenericTripleMatchFrame;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;

public class ConsumerChoicePointFrame
extends GenericTripleMatchFrame
implements LPAgendaEntry,
LPInterpreterState {
    protected Generator generator;
    protected int resultIndex;
    protected Node[] pVars;
    protected Node_RuleVariable[] trailVars;
    protected Node[] trailValues;
    protected int trailLength;
    protected LPInterpreterContext context;

    public ConsumerChoicePointFrame(LPInterpreter interpreter) {
        this.init(interpreter);
    }

    public void init(LPInterpreter interpreter) {
        super.init(interpreter);
        this.context = interpreter.getContext();
        this.generator = interpreter.getEngine().generatorFor(this.goal);
        this.generator.addConsumer(this);
        this.resultIndex = 0;
    }

    public void preserveState(List trail) {
        int trailLen = trail.size();
        if (trailLen > this.trailLength) {
            this.trailValues = new Node[trailLen];
            this.trailVars = new Node_RuleVariable[trailLen];
        }
        this.trailLength = trailLen;
        for (int i = 0; i < trailLen; ++i) {
            Node_RuleVariable var;
            this.trailVars[i] = var = (Node_RuleVariable)trail.get(i);
            this.trailValues[i] = var.getRawBoundValue();
        }
        Node[] currentPVars = this.envFrame.pVars;
        if (currentPVars != null) {
            if (this.pVars == null || this.pVars.length < currentPVars.length) {
                this.pVars = new Node[currentPVars.length];
            }
            System.arraycopy(currentPVars, 0, this.pVars, 0, currentPVars.length);
        }
    }

    public void restoreState(LPInterpreter interp) {
        interp.unwindTrail(0);
        for (int i = 0; i < this.trailLength; ++i) {
            interp.bind(this.trailVars[i], this.trailValues[i]);
        }
        if (this.pVars != null) {
            System.arraycopy(this.pVars, 0, this.envFrame.pVars, 0, this.pVars.length);
        }
    }

    public synchronized StateFlag nextMatch(LPInterpreter interpreter) {
        while (this.resultIndex < this.generator.results.size()) {
            Triple result = (Triple)this.generator.results.get(this.resultIndex++);
            if (this.resultIndex >= this.generator.results.size() && this.generator.isComplete()) {
                this.generator.removeConsumer(this);
            }
            if (!this.bindResult(result, interpreter)) continue;
            return StateFlag.SATISFIED;
        }
        if (this.generator.isComplete()) {
            this.setFinished();
            this.generator.removeConsumer(this);
            return StateFlag.FAIL;
        }
        return StateFlag.SUSPEND;
    }

    public boolean isReady() {
        return this.generator.numResults() > this.resultIndex;
    }

    public void setReady() {
        this.context.setReady(this);
    }

    public void setFinished() {
        this.context.notifyFinished(this);
    }

    public void pump() {
        if (this.context instanceof Generator) {
            ((Generator)this.context).pump(this);
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public LPInterpreterContext getConsumingContext() {
        return this.context;
    }
}

