/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;

public class Generator
implements LPAgendaEntry,
LPInterpreterContext {
    protected LPInterpreter interpreter;
    protected ArrayList results = new ArrayList();
    protected Set resultSet;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    protected Set generatingCPs = new HashSet();
    protected Set consumingCPs = new HashSet();
    protected LFlag completionState;
    protected TriplePattern goal;
    protected boolean isSingleton;

    public Generator(LPInterpreter interpreter, TriplePattern goal) {
        this.interpreter = interpreter;
        this.goal = goal;
        this.isSingleton = goal.isGround();
        if (!this.isSingleton) {
            this.resultSet = new HashSet();
        }
    }

    public int numResults() {
        return this.results.size();
    }

    public boolean isReady() {
        if (this.isComplete()) {
            return false;
        }
        if (this.checkReadyNeeded) {
            this.isReady = false;
            Iterator i = this.generatingCPs.iterator();
            while (i.hasNext()) {
                if (!((ConsumerChoicePointFrame)i.next()).isReady()) continue;
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    public void setReady(ConsumerChoicePointFrame ccp) {
        if (!this.isComplete()) {
            this.interpreter.engine.schedule(ccp);
            this.isReady = true;
            this.checkReadyNeeded = false;
        }
    }

    public boolean isComplete() {
        return this.interpreter == null;
    }

    public void setComplete() {
        if (!this.isComplete()) {
            this.interpreter.close();
            this.interpreter = null;
            this.resultSet = null;
            this.isReady = false;
            this.completionState = LFlag.DEAD;
            Iterator i = this.consumingCPs.iterator();
            while (i.hasNext()) {
                ConsumerChoicePointFrame ccp = (ConsumerChoicePointFrame)i.next();
                if (ccp.isReady()) continue;
                ccp.setFinished();
            }
            this.generatingCPs = null;
            this.consumingCPs.clear();
        }
    }

    public void addConsumer(ConsumerChoicePointFrame ccp) {
        this.consumingCPs.add(ccp);
    }

    public void removeConsumer(ConsumerChoicePointFrame ccp) {
        this.consumingCPs.remove(ccp);
    }

    public void notifyResults() {
        LPBRuleEngine engine = this.interpreter.getEngine();
        Iterator i = this.consumingCPs.iterator();
        while (i.hasNext()) {
            ConsumerChoicePointFrame cons = (ConsumerChoicePointFrame)i.next();
            cons.setReady();
        }
    }

    public void notifyBlockedOn(ConsumerChoicePointFrame ccp) {
        this.generatingCPs.add(ccp);
        this.checkReadyNeeded = true;
    }

    public void notifyFinished(ConsumerChoicePointFrame ccp) {
        if (this.generatingCPs != null) {
            this.generatingCPs.remove(ccp);
        }
        this.checkReadyNeeded = true;
    }

    public void pump() {
        this.pump(this);
    }

    public void pump(LPInterpreterState context) {
        if (this.isComplete()) {
            return;
        }
        this.interpreter.setState(context);
        int priorNresults = this.results.size();
        while (true) {
            Object result;
            if ((result = this.interpreter.next()) == StateFlag.FAIL) {
                this.checkReadyNeeded = true;
                break;
            }
            if (this.isSingleton) {
                this.results.add(result);
                this.isReady = false;
                break;
            }
            if (!this.resultSet.add(result)) continue;
            this.results.add(result);
        }
        if (this.results.size() > priorNresults) {
            this.notifyResults();
        }
        if (this.isSingleton && this.results.size() == 1) {
            this.setComplete();
        }
    }

    public Generator getGenerator() {
        return this;
    }

    public void checkForCompletions() {
        HashSet visited = new HashSet();
        if (this.runCompletionCheck(visited) != LFlag.LIVE) {
            Generator.postCompletionCheckScan(visited);
        }
    }

    public static void checkForCompletions(Collection completions) {
        HashSet visited = new HashSet();
        boolean atLeastOneZombie = false;
        Iterator i = completions.iterator();
        while (i.hasNext()) {
            Generator g = (Generator)i.next();
            if (g.runCompletionCheck(visited) == LFlag.LIVE) continue;
            atLeastOneZombie = true;
        }
        if (atLeastOneZombie) {
            Generator.postCompletionCheckScan(visited);
        }
    }

    protected LFlag runCompletionCheck(Set visited) {
        if (this.isComplete()) {
            return LFlag.DEAD;
        }
        if (!visited.add(this)) {
            return this.completionState;
        }
        this.completionState = LFlag.UNKNOWN;
        if (this.isReady()) {
            this.completionState = LFlag.LIVE;
        } else {
            Iterator i = this.generatingCPs.iterator();
            while (i.hasNext()) {
                ConsumerChoicePointFrame ccp = (ConsumerChoicePointFrame)i.next();
                if (ccp.isReady()) {
                    this.completionState = LFlag.LIVE;
                    break;
                }
                if (ccp.generator.runCompletionCheck(visited) != LFlag.LIVE) continue;
                this.completionState = LFlag.LIVE;
                break;
            }
        }
        return this.completionState;
    }

    protected static void postCompletionCheckScan(Set visited) {
        Generator g;
        Iterator iv = visited.iterator();
        while (iv.hasNext()) {
            g = (Generator)iv.next();
            if (g.completionState != LFlag.LIVE) continue;
            Iterator i = g.consumingCPs.iterator();
            while (i.hasNext()) {
                LPInterpreterContext link = ((ConsumerChoicePointFrame)i.next()).getConsumingContext();
                if (!(link instanceof Generator)) continue;
                ((Generator)link).propagateLive(visited);
            }
        }
        iv = visited.iterator();
        while (iv.hasNext()) {
            g = (Generator)iv.next();
            if (g.completionState == LFlag.LIVE) continue;
            g.setComplete();
        }
    }

    protected void propagateLive(Set filter) {
        if (this.completionState != LFlag.LIVE) {
            this.completionState = LFlag.LIVE;
            Iterator i = this.consumingCPs.iterator();
            while (i.hasNext()) {
                LPInterpreterContext link = ((ConsumerChoicePointFrame)i.next()).getConsumingContext();
                if (!(link instanceof Generator)) continue;
                ((Generator)link).propagateLive(filter);
            }
        }
    }

    private static class LFlag {
        private String label;
        public static final LFlag LIVE = new LFlag("Live");
        public static final LFlag DEAD = new LFlag("Dead");
        public static final LFlag UNKNOWN = new LFlag("Unknown");

        private LFlag(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

