/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;

public class LPBindingEnvironment
implements BindingEnvironment {
    protected LPInterpreter interpreter;

    public LPBindingEnvironment(LPInterpreter interpeter) {
        this.interpreter = interpeter;
    }

    public Node getGroundVersion(Node node) {
        return LPInterpreter.deref(node);
    }

    public boolean bind(Node var, Node value) {
        Node dvar = var;
        if (dvar instanceof Node_RuleVariable) {
            dvar = ((Node_RuleVariable)dvar).deref();
        }
        if (dvar instanceof Node_RuleVariable) {
            this.interpreter.bind(dvar, value);
            return true;
        }
        return var.sameValueAs(value);
    }

    public Triple instantiate(TriplePattern pattern) {
        Node o;
        Node p;
        Node s = this.getGroundVersion(pattern.getSubject());
        if (s.isVariable()) {
            s = Node.createAnon();
        }
        if ((p = this.getGroundVersion(pattern.getPredicate())).isVariable()) {
            p = Node.createAnon();
        }
        if ((o = this.getGroundVersion(pattern.getObject())).isVariable()) {
            o = Node.createAnon();
        }
        return new Triple(s, p, o);
    }
}

