/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;

public class LPRuleStore
extends RuleStore {
    protected boolean isCompiled = false;
    protected Map predicateToCodeMap;
    protected ArrayList allRuleClauseCodes;
    protected Map indexPredicateToCodeMap;
    protected HashSet tabledPredicates = new HashSet();
    private static final int INDEX_THRESHOLD = 20;
    protected boolean allTabled = false;

    public LPRuleStore(List rules) {
        super(rules);
    }

    public LPRuleStore() {
    }

    public void addAll(LPRuleStore store) {
        super.addAll(store);
        this.tabledPredicates.addAll(store.tabledPredicates);
        this.allTabled = this.tabledPredicates.contains(Node.ANY);
    }

    public synchronized void tablePredicate(Node predicate) {
        this.tabledPredicates.add(predicate);
        if (predicate == Node.ANY) {
            this.allTabled = true;
        }
    }

    public List codeFor(Node predicate) {
        if (!this.isCompiled) {
            this.compileAll();
        }
        if (predicate.isVariable()) {
            return this.allRuleClauseCodes;
        }
        List codeList = (List)this.predicateToCodeMap.get(predicate);
        if (codeList == null) {
            codeList = (List)this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        }
        return codeList;
    }

    public List codeFor(TriplePattern goal) {
        List indexedCode;
        List allRules = this.codeFor(goal.getPredicate());
        if (allRules == null) {
            return allRules;
        }
        Map indexedCodeTable = (Map)this.indexPredicateToCodeMap.get(goal.getPredicate());
        if (indexedCodeTable != null && (indexedCode = (List)indexedCodeTable.get(goal.getObject())) != null) {
            return indexedCode;
        }
        return allRules;
    }

    public boolean isIndexedPredicate(Node predicate) {
        return this.indexPredicateToCodeMap.get(predicate) != null;
    }

    public boolean isTabled(TriplePattern goal) {
        return this.isTabled(goal.getPredicate());
    }

    public boolean isTabled(Node predicate) {
        if (this.allTabled) {
            return true;
        }
        if (predicate.isVariable() && !this.tabledPredicates.isEmpty()) {
            return true;
        }
        return this.tabledPredicates.contains(predicate);
    }

    protected void compileAll() {
        Node predicate;
        Map.Entry entry;
        Iterator i;
        this.isCompiled = true;
        this.predicateToCodeMap = new HashMap();
        this.allRuleClauseCodes = new ArrayList();
        this.indexPredicateToCodeMap = new HashMap();
        Iterator ri = this.getAllRules().iterator();
        while (ri.hasNext()) {
            ArrayList<RuleClauseCode> predicateCode;
            Rule r = (Rule)ri.next();
            ClauseEntry term = r.getHeadElement(0);
            if (!(term instanceof TriplePattern)) continue;
            RuleClauseCode code = new RuleClauseCode(r);
            this.allRuleClauseCodes.add(code);
            Node predicate2 = ((TriplePattern)term).getPredicate();
            if (predicate2.isVariable()) {
                predicate2 = Node_RuleVariable.WILD;
            }
            if ((predicateCode = (ArrayList<RuleClauseCode>)this.predicateToCodeMap.get(predicate2)) == null) {
                predicateCode = new ArrayList<RuleClauseCode>();
                this.predicateToCodeMap.put(predicate2, predicateCode);
            }
            predicateCode.add(code);
            if (predicateCode.size() <= 20) continue;
            this.indexPredicateToCodeMap.put(predicate2, new HashMap());
        }
        List wildRules = (List)this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        if (wildRules != null) {
            i = this.predicateToCodeMap.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                predicate = (Node)entry.getKey();
                List predicateCode = (List)entry.getValue();
                if (predicate == Node_RuleVariable.WILD) continue;
                predicateCode.addAll(wildRules);
            }
        }
        this.indexPredicateToCodeMap.put(Node_RuleVariable.WILD, new HashMap());
        i = this.indexPredicateToCodeMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            predicate = (Node)entry.getKey();
            HashMap predicateMap = (HashMap)entry.getValue();
            ArrayList<RuleClauseCode> wildRulesForPredicate = new ArrayList<RuleClauseCode>();
            ArrayList allRulesForPredicate = predicate.isVariable() ? this.allRuleClauseCodes : (List)this.predicateToCodeMap.get(predicate);
            Iterator j = allRulesForPredicate.iterator();
            while (j.hasNext()) {
                Node objectPattern;
                RuleClauseCode code = (RuleClauseCode)j.next();
                ClauseEntry head = code.getRule().getHeadElement(0);
                boolean indexed = false;
                if (head instanceof TriplePattern && !(objectPattern = ((TriplePattern)head).getObject()).isVariable() && !Functor.isFunctor(objectPattern)) {
                    ArrayList<RuleClauseCode> indexedCode = (ArrayList<RuleClauseCode>)predicateMap.get(objectPattern);
                    if (indexedCode == null) {
                        indexedCode = new ArrayList<RuleClauseCode>();
                        predicateMap.put(objectPattern, indexedCode);
                    }
                    indexedCode.add(code);
                    indexed = true;
                }
                if (indexed) continue;
                wildRulesForPredicate.add(code);
            }
            Iterator k = predicateMap.entrySet().iterator();
            while (k.hasNext()) {
                Map.Entry ent = k.next();
                Node pred = (Node)ent.getKey();
                List predicateCode = (List)ent.getValue();
                predicateCode.addAll(wildRulesForPredicate);
            }
        }
        i = this.allRuleClauseCodes.iterator();
        while (i.hasNext()) {
            RuleClauseCode code = (RuleClauseCode)((Object)i.next());
            code.compile(this);
        }
    }

    protected void doAddRemoveRule(Rule rule, boolean isAdd) {
        this.isCompiled = false;
        super.doAddRemoveRule(rule, isAdd);
    }
}

