/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;

public class LPTopGoalIterator
implements ClosableIterator,
LPInterpreterContext {
    Object lookAhead;
    LPInterpreter interpreter;
    protected Set choicePoints = new HashSet();
    protected ConsumerChoicePointFrame nextToRun;
    protected boolean isReady = true;
    protected boolean checkReadyNeeded = false;
    boolean started = false;

    public LPTopGoalIterator(LPInterpreter engine) {
        this.interpreter = engine;
        engine.setTopInterpreter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void moveForward() {
        if (this.interpreter == null || this.interpreter.getEngine() == null) {
            throw new ConcurrentModificationException("Call to closed iterator");
        }
        LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
        synchronized (lPBRuleEngine) {
            this.started = true;
            this.lookAhead = this.interpreter.next();
            if (this.lookAhead == StateFlag.FAIL) {
                if (this.choicePoints.isEmpty()) {
                    this.close();
                } else {
                    this.nextToRun = null;
                    this.interpreter.getEngine().pump(this);
                    if (this.nextToRun == null) {
                        this.close();
                    } else {
                        this.interpreter.setState(this.nextToRun);
                        this.moveForward();
                    }
                }
            }
        }
    }

    public void notifyBlockedOn(ConsumerChoicePointFrame ccp) {
        this.choicePoints.add(ccp);
        this.checkReadyNeeded = true;
    }

    public void notifyFinished(ConsumerChoicePointFrame ccp) {
        this.choicePoints.remove(ccp);
        this.checkReadyNeeded = true;
    }

    public void setReady(ConsumerChoicePointFrame ccp) {
        this.nextToRun = ccp;
        this.isReady = true;
        this.checkReadyNeeded = false;
    }

    public boolean isReady() {
        if (this.checkReadyNeeded) {
            this.isReady = false;
            Iterator i = this.choicePoints.iterator();
            while (i.hasNext()) {
                ConsumerChoicePointFrame ccp = (ConsumerChoicePointFrame)i.next();
                if (!ccp.isReady()) continue;
                if (this.nextToRun == null) {
                    this.nextToRun = ccp;
                }
                this.isReady = true;
                break;
            }
            this.checkReadyNeeded = false;
            return this.isReady;
        }
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.interpreter != null) {
            LPBRuleEngine lPBRuleEngine = this.interpreter.getEngine();
            synchronized (lPBRuleEngine) {
                this.interpreter.getEngine().checkForCompletions();
                this.lookAhead = null;
                this.interpreter.close();
                this.interpreter = null;
                this.isReady = false;
                this.checkReadyNeeded = false;
                this.nextToRun = null;
            }
        }
    }

    public boolean hasNext() {
        if (!this.started) {
            this.moveForward();
        }
        return this.lookAhead != null;
    }

    public Object next() {
        if (!this.started) {
            this.moveForward();
        }
        if (this.lookAhead == null) {
            throw new NoSuchElementException("Overran end of LP result set");
        }
        Object result = this.lookAhead;
        this.moveForward();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

