/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class OWLRuleTranslationHook
implements RulePreprocessHook {
    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator it = dataFind.find(new TriplePattern(null, OWL.intersectionOf.asNode(), null));
        while (it.hasNext()) {
            Triple decl = (Triple)it.next();
            Node className = decl.getSubject();
            ArrayList elements = new ArrayList();
            OWLRuleTranslationHook.translateIntersectionList(decl.getObject(), dataFind, elements);
            ArrayList<TriplePattern> recognitionBody = new ArrayList<TriplePattern>();
            Node_RuleVariable var = new Node_RuleVariable("?x", 0);
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Node description = (Node)i.next();
                Rule ir = new Rule("intersectionImplication", new ClauseEntry[]{new TriplePattern(className, RDFS.subClassOf.asNode(), description)}, new ClauseEntry[0]);
                ir.setBackward(false);
                infGraph.addRuleDuringPrepare(ir);
                recognitionBody.add(new TriplePattern(var, RDF.type.asNode(), description));
            }
            ArrayList<TriplePattern> recognitionHead = new ArrayList<TriplePattern>(1);
            recognitionHead.add(new TriplePattern(var, RDF.type.asNode(), className));
            Rule rr = new Rule("intersectionRecognition", recognitionHead, recognitionBody);
            rr.setBackward(true);
            infGraph.addRuleDuringPrepare(rr);
        }
    }

    protected static void translateIntersectionList(Node node, Finder dataFind, List elements) {
        if (node == null) {
            throw new ReasonerException("Illegal list structure in owl:intersectionOf");
        }
        if (node.equals(RDF.nil.asNode())) {
            return;
        }
        Node description = Util.getPropValue(node, RDF.first.asNode(), dataFind);
        if (description == null) {
            throw new ReasonerException("Illegal list structure in owl:intersectionOf");
        }
        elements.add(description);
        Node next = Util.getPropValue(node, RDF.rest.asNode(), dataFind);
        OWLRuleTranslationHook.translateIntersectionList(next, dataFind, elements);
    }

    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t) {
        return t.getPredicate().equals(OWL.intersectionOf.asNode());
    }
}

