/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.HashSet;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class RDFSCMPPreprocessHook
implements RulePreprocessHook {
    protected static String memberPrefix = RDF.getURI() + "_";

    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator it = dataFind.find(new TriplePattern(null, null, null));
        HashSet<Node> properties = new HashSet<Node>();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            Node prop = triple.getPredicate();
            if (prop.equals(RDF.Nodes.type) && triple.getObject().equals(RDF.Nodes.Property)) {
                prop = triple.getSubject();
            }
            if (!properties.add(prop) || !prop.getURI().startsWith(memberPrefix)) continue;
            inserts.add(new Triple(prop, RDF.Nodes.type, RDFS.Nodes.ContainerMembershipProperty));
        }
    }

    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t) {
        return t.getPredicate().getURI().startsWith(memberPrefix);
    }
}

