/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import mx.com.hp.hpl.jena.reasoner.rulesys.Builtin;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;

public class RETERuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected RETEEngine engine;

    public RETERuleContext(ForwardRuleInfGraphI graph, RETEEngine engine) {
        this.graph = graph;
        this.engine = engine;
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public RETEEngine getEngine() {
        return this.engine;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public boolean contains(Node s, Node p, Node o) {
        ClosableIterator it = this.find(s, p, o);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public ClosableIterator find(Node s, Node p, Node o) {
        return this.graph.findDataMatches(s, p, o);
    }

    public void silentAdd(Triple t) {
        this.graph.silentAdd(t);
    }

    public void remove(Triple t) {
        this.graph.getRawGraph().delete(t);
        this.engine.deleteTriple(t, true);
    }

    public void add(Triple t) {
        this.engine.addTriple(t, true);
    }

    public boolean shouldFire(boolean allowUnsafe) {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || !(allowUnsafe ? !((Functor)clause).evalAsBodyClause(this) : !((Functor)clause).safeEvalAsBodyClause(this))) continue;
            return false;
        }
        return true;
    }

    public boolean shouldStillFire() {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            Builtin builtin;
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || (builtin = ((Functor)clause).getImplementor()) == null || builtin.isMonotonic() || ((Functor)clause).evalAsBodyClause(this)) continue;
            return false;
        }
        return true;
    }
}

