/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.util.OneToManyMap;

public class RuleStore {
    protected OneToManyMap goalMap = new OneToManyMap();
    protected List allRules;
    protected Set ruleIndex = new HashSet();

    public RuleStore() {
        this.allRules = new ArrayList();
    }

    public RuleStore(List rules) {
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            this.addRule((Rule)i.next());
        }
        this.allRules = rules;
    }

    public void addAll(RuleStore store) {
        Iterator i = store.getAllRules().iterator();
        while (i.hasNext()) {
            this.addRule((Rule)i.next());
        }
    }

    public void addRule(Rule rule) {
        this.addRemoveRule(rule, true);
    }

    public void deleteRule(Rule rule) {
        this.addRemoveRule(rule, false);
    }

    private void addRemoveRule(Rule rule, boolean isAdd) {
        if (rule.headLength() != 1) {
            for (int j = 0; j < rule.headLength(); ++j) {
                Rule newRule = new Rule(rule.getName(), new ClauseEntry[]{rule.getHeadElement(j)}, rule.getBody());
                newRule.setNumVars(rule.getNumVars());
                this.doAddRemoveRule(newRule, isAdd);
            }
        } else {
            this.doAddRemoveRule(rule, isAdd);
        }
    }

    protected void doAddRemoveRule(Rule rule, boolean isAdd) {
        ClauseEntry headClause;
        if (isAdd && this.ruleIndex.contains(rule)) {
            return;
        }
        if (isAdd) {
            this.ruleIndex.add(rule);
            if (this.allRules != null) {
                this.allRules.add(rule);
            }
        } else {
            this.ruleIndex.remove(rule);
            if (this.allRules != null) {
                this.allRules.remove(rule);
            }
        }
        if ((headClause = rule.getHeadElement(0)) instanceof TriplePattern) {
            TriplePattern headpattern = (TriplePattern)headClause;
            Node predicate = headpattern.getPredicate();
            if (predicate.isVariable()) {
                if (isAdd) {
                    this.goalMap.put(Node.ANY, rule);
                } else {
                    this.goalMap.remove(Node.ANY, rule);
                }
            } else if (isAdd) {
                this.goalMap.put(predicate, rule);
            } else {
                this.goalMap.remove(predicate, rule);
            }
        }
    }

    public List rulesFor(TriplePattern goal) {
        ArrayList rules = new ArrayList();
        if (goal.getPredicate().isVariable()) {
            this.checkAll(this.goalMap.values().iterator(), goal, rules);
        } else {
            this.checkAll(this.goalMap.getAll(goal.getPredicate()), goal, rules);
            this.checkAll(this.goalMap.getAll(Node.ANY), goal, rules);
        }
        return rules;
    }

    public List getAllRules() {
        return this.allRules;
    }

    public void deleteAllRules() {
        this.allRules.clear();
        this.goalMap.clear();
        this.ruleIndex.clear();
    }

    private void checkAll(Iterator candidates, TriplePattern goal, List matchingRules) {
        while (candidates.hasNext()) {
            Rule r = (Rule)candidates.next();
            if (!((TriplePattern)r.getHeadElement(0)).compatibleWith(goal)) continue;
            matchingRules.add(r);
        }
    }
}

