/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl;

import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;

public final class WrappedReasonerFactory
implements ReasonerFactory {
    protected final ReasonerFactory factory;
    protected final Resource config;
    protected final Model schemaUnion = ModelFactory.createDefaultModel();

    public WrappedReasonerFactory(ReasonerFactory rrf, Resource config) {
        this.factory = rrf;
        this.config = config;
        WrappedReasonerFactory.loadSchemas(this.schemaUnion, config);
    }

    public Reasoner create(Resource ignored) {
        Reasoner result = this.factory.create(this.config);
        return this.schemaUnion.isEmpty() ? result : result.bindSchema(this.schemaUnion);
    }

    private static Model loadSchemas(Model schema, Resource R) {
        StmtIterator schemas = R.listProperties(JenaModelSpec.schemaURL);
        while (schemas.hasNext()) {
            Statement s = schemas.nextStatement();
            Resource sc = s.getResource();
            FileManager.get().readModel(schema, sc.getURI());
        }
        return schema;
    }

    public Model getCapabilities() {
        return this.factory.getCapabilities();
    }

    public String getURI() {
        return this.factory.getURI();
    }
}

