/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Factory;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.FinderUtil;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import mx.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.TopGoalIterator;
import mx.com.hp.hpl.jena.util.OneToManyMap;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicBackwardRuleInfGraph
extends BaseInfGraph
implements BackwardRuleInfGraphI {
    protected List rules;
    protected OneToManyMap derivations;
    protected FGraph fschema;
    protected FGraph fdeductions;
    protected Finder dataFind;
    protected BRuleEngine engine;
    protected BBRuleContext context;
    protected TempNodeCache tempNodecache;
    int nRulesTriggered = 0;
    long nRulesFired = 0L;
    long nRulesThreshold = 500000L;
    boolean traceOn = false;
    public static final long DEFAULT_RULES_THRESHOLD = 500000L;
    static Log logger = LogFactory.getLog((Class)BasicBackwardRuleInfGraph.class);

    public BasicBackwardRuleInfGraph(Reasoner reasoner, RuleStore ruleStore, Graph data, Graph schema) {
        super(data, reasoner);
        if (schema != null) {
            this.fschema = new FGraph(schema);
        }
        this.rules = ruleStore.getAllRules();
        this.engine = new BRuleEngine(this, ruleStore);
        this.tempNodecache = new TempNodeCache(this);
    }

    public Graph getSchemaGraph() {
        return this.fschema.getGraph();
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.fdeductions = new FGraph(Factory.createGraphMem());
            this.extractAxioms();
            this.dataFind = this.fdata;
            if (this.fdeductions != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fdeductions);
            }
            if (this.fschema != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fschema);
            }
            this.context = new BBRuleContext(this);
        }
        this.isPrepared = true;
    }

    public void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.engine.reset();
        this.isPrepared = false;
    }

    public void rebind() {
        this.engine.reset();
        this.isPrepared = false;
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = null;
        result = continuation == null ? WrappedIterator.create(new TopGoalIterator(this.engine, pattern)) : WrappedIterator.create(new TopGoalIterator(this.engine, pattern)).andThen(continuation.find(pattern));
        return result.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    public void reset() {
        this.engine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.reset();
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.reset();
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public Iterator getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(t);
    }

    public void setRuleThreshold(long threshold) {
        this.nRulesThreshold = threshold;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
        this.engine.setTraceOn(state);
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void dump() {
        this.engine.dump();
    }

    public void logDerivation(Triple t, Object derivation) {
        this.derivations.put(t, derivation);
    }

    public ExtendedIterator findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        if (clause instanceof Functor) {
            this.context.setEnv(env);
            this.context.setRule(rule);
            return ((Functor)clause).evalAsBodyClause(this.context);
        }
        throw new ReasonerException("Illegal builtin predicate: " + clause + " in rule " + rule);
    }

    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    protected void extractAxioms() {
        Graph axioms = this.fdeductions.getGraph();
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            if (rule.bodyLength() != 0) continue;
            for (int j = 0; j < rule.headLength(); ++j) {
                ClauseEntry axiom = rule.getHeadElement(j);
                if (!(axiom instanceof TriplePattern)) continue;
                axioms.add(((TriplePattern)axiom).asTriple());
            }
        }
    }
}

