/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoalResults {
    protected TriplePattern goal;
    protected ArrayList resultSet;
    protected HashSet resultSetIndex;
    protected boolean isComplete;
    protected boolean started = false;
    protected Set dependents = new HashSet();
    protected BRuleEngine engine;
    protected int refCount = 0;
    protected boolean isSingleton = false;
    static Log logger = LogFactory.getLog((Class)GoalResults.class);

    public GoalResults(TriplePattern goal, BRuleEngine ruleEngine) {
        this.goal = goal;
        this.resultSet = new ArrayList();
        this.resultSetIndex = new HashSet();
        this.isComplete = false;
        this.engine = ruleEngine;
        this.isSingleton = !goal.getSubject().isVariable() && !goal.getPredicate().isVariable() && !goal.getObject().isVariable();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public int numResults() {
        if (!this.started) {
            this.start();
        }
        return this.resultSet.size();
    }

    public Triple getResult(int n) {
        return (Triple)this.resultSet.get(n);
    }

    public void addDependent(RuleState dependent) {
        if (!this.isComplete) {
            this.dependents.add(dependent);
        }
    }

    public void flushDependents() {
        Iterator i = this.dependents.iterator();
        while (i.hasNext()) {
            RuleState dep = (RuleState)i.next();
            this.engine.prependToAgenda(dep);
        }
    }

    public BRuleEngine getEngine() {
        return this.engine;
    }

    public void setComplete() {
        if (!this.isComplete) {
            if (this.engine.isTraceOn()) {
                logger.debug((Object)("Completed " + this));
            }
            this.isComplete = true;
            this.resultSetIndex = null;
            this.flushDependents();
            this.dependents.clear();
        }
    }

    public void setAllComplete() {
        this.isComplete = true;
        this.dependents.clear();
    }

    public void start() {
        List rules = this.engine.rulesFor(this.goal);
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            RuleState rs = RuleState.createInitialState(rule, this);
            if (rs == null) continue;
            this.engine.appendToAgenda(rs);
        }
        if (this.refCount <= 0) {
            this.setComplete();
        }
        this.started = true;
    }

    public boolean addResult(Triple result) {
        if (!this.isComplete && !this.resultSetIndex.contains(result)) {
            this.resultSet.add(result);
            this.resultSetIndex.add(result);
            if (this.isSingleton) {
                this.setComplete();
            } else {
                this.flushDependents();
            }
            return true;
        }
        return false;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.setComplete();
        }
    }

    public String toString() {
        return "GoalResult for: " + this.goal;
    }
}

