/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import mx.com.hp.hpl.jena.shared.WrappedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLExptRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List ruleSet;
    protected static FBRuleInfGraph preload;
    private static final boolean USE_LP = true;
    protected static Log logger;

    public OWLExptRuleReasoner(ReasonerFactory factory) {
        super(OWLExptRuleReasoner.loadRules(), factory);
    }

    private OWLExptRuleReasoner(OWLExptRuleReasoner parent, InfGraph schemaGraph) {
        super(parent.rules, schemaGraph, parent.factory);
    }

    public static List loadRules() {
        if (ruleSet == null) {
            try {
                ruleSet = Rule.parseRules(Util.loadRuleParserFromResourceFile(RULE_FILE));
            }
            catch (WrappedIOException e) {
                throw new ReasonerException("Can't load rules file: etc/owl-fb.rules", e);
            }
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = this.makeInfGraph(this.rules, tbox, true);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.prepare();
        return new OWLExptRuleReasoner(this, graph);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        FBRuleInfGraph graph = null;
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List baseRules = ((FBRuleInfGraph)schemaArg).getRules();
        graph = this.makeInfGraph(baseRules, schemaArg, false);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.isTraceOn());
        graph.rebind(data);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfGraph getPreload() {
        Class clazz = OWLExptRuleReasoner.class;
        synchronized (clazz) {
            if (preload == null) {
                preload = this.makeInfGraph(this.rules, null, false);
                preload.prepare();
            }
            return preload;
        }
    }

    private FBRuleInfGraph makeInfGraph(List rules, Graph schema, boolean doPreload) {
        if (doPreload) {
            return new FBRuleInfGraph(this, rules, this.getPreload(), schema);
        }
        return new FBRuleInfGraph(this, rules, schema);
    }

    static {
        logger = LogFactory.getLog((Class)OWLExptRuleReasoner.class);
    }
}

