/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import mx.com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import mx.com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.Rule;
import mx.com.hp.hpl.jena.reasoner.rulesys.Util;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLRuleReasonerFactory;
import mx.com.hp.hpl.jena.shared.WrappedIOException;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLRuleReasoner
extends BasicForwardRuleReasoner {
    protected static final String RULE_FILE = "etc/owl.rules";
    protected static List ruleSet;
    protected static Log logger;
    protected static long nRulesFired;
    protected static long timeCost;

    public OWLRuleReasoner() {
        super(OWLRuleReasoner.loadRules(), OWLRuleReasonerFactory.theInstance());
    }

    private OWLRuleReasoner(List rules, InfGraph schemaGraph) {
        super(rules, OWLRuleReasonerFactory.theInstance());
        this.rules = rules;
        this.schemaGraph = schemaGraph;
    }

    public static List loadRules() {
        if (ruleSet == null) {
            try {
                ruleSet = Rule.parseRules(Util.loadRuleParserFromResourceFile(RULE_FILE));
            }
            catch (WrappedIOException e) {
                throw new ReasonerException("Can't load rules file: etc/owl.rules", e);
            }
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, this.rules, tbox);
        ExtendedIterator i = tbox.find(null, OWL.intersectionOf.asNode(), null);
        ArrayList rules = (ArrayList)ruleSet;
        if (i.hasNext()) {
            rules = (ArrayList)rules.clone();
            while (i.hasNext()) {
                this.translateIntersectionOf((Triple)i.next(), rules, tbox);
            }
        }
        return new OWLRuleReasoner((List)rules, graph);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        long startTime = System.currentTimeMillis();
        ExtendedIterator i = data.find(null, OWL.intersectionOf.asNode(), null);
        ArrayList rules = (ArrayList)ruleSet;
        if (i.hasNext()) {
            rules = (ArrayList)rules.clone();
            while (i.hasNext()) {
                this.translateIntersectionOf((Triple)i.next(), rules, data);
            }
        }
        BasicForwardRuleInfGraph graph = new BasicForwardRuleInfGraph(this, rules, this.schemaGraph);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        long endTime = System.currentTimeMillis();
        timeCost = (long)((double)timeCost + (double)(endTime - startTime));
        nRulesFired += graph.getNRulesFired();
        return graph;
    }

    public static void printStats() {
        logger.info((Object)("Fired " + nRulesFired + " over " + (double)timeCost / 1000.0 + " s = " + nRulesFired * 1000L / timeCost + " r/s"));
    }

    private void translateIntersectionOf(Triple decl, List rules, Graph data) {
        Node className = decl.getSubject();
        ArrayList elements = new ArrayList();
        this.translateIntersectionList(decl.getObject(), data, elements);
        ArrayList<TriplePattern> recognitionBody = new ArrayList<TriplePattern>();
        Node_RuleVariable var = new Node_RuleVariable("?x", 0);
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Node description = (Node)i.next();
            Rule ir = new Rule("intersectionImplication", new ClauseEntry[]{new TriplePattern(className, RDFS.subClassOf.asNode(), description)}, new ClauseEntry[0]);
            rules.add(ir);
            recognitionBody.add(new TriplePattern(var, RDF.type.asNode(), description));
        }
        ArrayList<TriplePattern> recognitionHead = new ArrayList<TriplePattern>(1);
        recognitionHead.add(new TriplePattern(var, RDF.type.asNode(), className));
        Rule rr = new Rule("intersectionRecognition", recognitionHead, recognitionBody);
        rules.add(rr);
    }

    private void translateIntersectionList(Node node, Graph data, List elements) {
        if (node.equals(RDF.nil.asNode())) {
            return;
        }
        Node description = Util.getPropValue(node, RDF.first.asNode(), data);
        if (data.contains(description, RDF.type.asNode(), OWL.Restriction.asNode())) {
            Node onprop = Util.getPropValue(description, OWL.onProperty.asNode(), data);
            Node value = Util.getPropValue(description, OWL.allValuesFrom.asNode(), data);
            if (value != null) {
                elements.add(Functor.makeFunctorNode("all", new Node[]{onprop, value}));
            } else {
                value = Util.getPropValue(description, OWL.someValuesFrom.asNode(), data);
                if (value != null) {
                    elements.add(Functor.makeFunctorNode("some", new Node[]{onprop, value}));
                } else {
                    value = Util.getPropValue(description, OWL.minCardinality.asNode(), data);
                    if (value != null) {
                        elements.add(Functor.makeFunctorNode("min", new Node[]{onprop, value}));
                    } else {
                        value = Util.getPropValue(description, OWL.maxCardinality.asNode(), data);
                        if (value != null) {
                            elements.add(Functor.makeFunctorNode("max", new Node[]{onprop, value}));
                        } else {
                            value = Util.getPropValue(description, OWL.cardinality.asNode(), data);
                            if (value != null) {
                                elements.add(Functor.makeFunctorNode("max", new Node[]{onprop, value}));
                                elements.add(Functor.makeFunctorNode("min", new Node[]{onprop, value}));
                            }
                        }
                    }
                }
            }
        } else {
            elements.add(description);
        }
        Node next = Util.getPropValue(node, RDF.rest.asNode(), data);
        this.translateIntersectionList(next, data, elements);
    }

    static {
        logger = LogFactory.getLog((Class)OWLRuleReasoner.class);
        nRulesFired = 0L;
        timeCost = 0L;
    }
}

