/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.Trail;

public class TestTrail
extends TestCase {
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");

    public TestTrail(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTrail.class);
    }

    public void testUnify() {
        Node_RuleVariable X = new Node_RuleVariable("x", 0);
        Node_RuleVariable Y = new Node_RuleVariable("y", 1);
        Node_RuleVariable Z = new Node_RuleVariable("z", 2);
        Trail trail = new Trail();
        TestTrail.assertTrue((boolean)trail.unify(new TriplePattern(X, this.p, Y), new TriplePattern(this.a, this.p, this.b)));
        TestTrail.assertEquals((Object)X.deref(), (Object)this.a);
        TestTrail.assertEquals((Object)Y.deref(), (Object)this.b);
        TestTrail.assertTrue((boolean)Z.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue((boolean)X.isUnbound());
        TestTrail.assertTrue((boolean)Y.isUnbound());
        TestTrail.assertTrue((boolean)trail.unify(new TriplePattern(X, this.p, X), new TriplePattern(Z, this.p, this.a)));
        TestTrail.assertEquals((Object)X.deref(), (Object)this.a);
        TestTrail.assertEquals((Object)Z.deref(), (Object)this.a);
        trail.unwindAndClear();
        TriplePattern gf = new TriplePattern(X, this.p, Functor.makeFunctorNode("f", new Node[]{X, this.b}));
        TriplePattern hf1 = new TriplePattern(Y, this.p, Functor.makeFunctorNode("f", new Node[]{Z, this.b}));
        TriplePattern hf2 = new TriplePattern(Y, this.p, Functor.makeFunctorNode("f", new Node[]{this.a, Y}));
        TriplePattern hf3 = new TriplePattern(Y, this.p, Functor.makeFunctorNode("f", new Node[]{this.b, Y}));
        TestTrail.assertTrue((boolean)trail.unify(gf, hf1));
        TestTrail.assertEquals((Object)X.deref(), (Object)Y.deref());
        TestTrail.assertEquals((Object)X.deref(), (Object)Z.deref());
        trail.unwindAndClear();
        TestTrail.assertTrue((!trail.unify(gf, hf2) ? 1 : 0) != 0);
        TestTrail.assertTrue((boolean)X.isUnbound());
        TestTrail.assertTrue((boolean)Y.isUnbound());
        TestTrail.assertTrue((boolean)Z.isUnbound());
        trail.unwindAndClear();
        TestTrail.assertTrue((boolean)trail.unify(gf, hf3));
        TestTrail.assertEquals((Object)X.deref(), (Object)this.b);
        TestTrail.assertEquals((Object)Y.deref(), (Object)this.b);
        trail.unwindAndClear();
    }

    public void testMatching() {
        Node_RuleVariable X = new Node_RuleVariable("x", 0);
        Node_RuleVariable Y = new Node_RuleVariable("y", 1);
        Node_RuleVariable Z = new Node_RuleVariable("z", 2);
        Node_RuleVariable X1 = new Node_RuleVariable("x1", 0);
        Node_RuleVariable Y1 = new Node_RuleVariable("y1", 1);
        Node_RuleVariable Z1 = new Node_RuleVariable("z1", 2);
        TestTrail.assertTrue((boolean)X.sameValueAs(Y));
        TriplePattern f1 = new TriplePattern(X, this.p, Functor.makeFunctorNode("f", new Node[]{X, this.b}));
        TriplePattern f2 = new TriplePattern(Y, this.p, Functor.makeFunctorNode("f", new Node[]{Z, this.b}));
        TriplePattern f3 = new TriplePattern(Y1, this.p, Functor.makeFunctorNode("f", new Node[]{Y1, this.b}));
        TriplePattern f4 = new TriplePattern(X1, this.p, Functor.makeFunctorNode("f", new Node[]{Z1, this.b}));
        TestTrail.assertEquals((Object)f1, (Object)f2);
        TestTrail.assertEquals((int)f1.hashCode(), (int)f2.hashCode());
        TestTrail.assertTrue((boolean)f1.variantOf(f3));
        TestTrail.assertTrue((boolean)f2.variantOf(f4));
        TestTrail.assertTrue((!f1.variantOf(f2) ? 1 : 0) != 0);
        TestTrail.assertTrue((!f3.variantOf(f4) ? 1 : 0) != 0);
    }
}

