/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import java.util.ArrayList;
import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import mx.com.hp.hpl.jena.reasoner.rulesys.Functor;
import mx.com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;

public class Trail
implements BindingEnvironment {
    protected ArrayList trail = new ArrayList();

    public void unwindBindings() {
        for (int i = this.trail.size() - 1; i >= 0; --i) {
            TrailEntry entry = (TrailEntry)this.trail.get(i);
            entry.var.unbind();
        }
    }

    public void unwindAndClear() {
        for (int i = this.trail.size() - 1; i >= 0; --i) {
            TrailEntry entry = (TrailEntry)this.trail.get(i);
            entry.var.unbind();
        }
        this.trail.clear();
    }

    public void activate() {
        Iterator i = this.trail.iterator();
        while (i.hasNext()) {
            TrailEntry entry = (TrailEntry)i.next();
            entry.var.simpleBind(entry.value);
        }
    }

    public boolean unify(TriplePattern t, TriplePattern tp) {
        boolean ok;
        int watermark = this.trail.size();
        boolean bl = ok = this.unify(t.getSubject(), tp.getSubject()) && this.unify(t.getPredicate(), tp.getPredicate()) && this.unifyObj(t.getObject(), tp.getObject());
        if (!ok) {
            for (int i = this.trail.size() - 1; i >= watermark; --i) {
                TrailEntry entry = (TrailEntry)this.trail.get(i);
                entry.var.unbind();
                this.trail.remove(i);
            }
        }
        return ok;
    }

    public boolean unify(Triple t, TriplePattern tp) {
        boolean ok;
        int watermark = this.trail.size();
        boolean bl = ok = this.unify(t.getSubject(), tp.getSubject()) && this.unify(t.getPredicate(), tp.getPredicate()) && this.unifyObj(t.getObject(), tp.getObject());
        if (!ok) {
            for (int i = this.trail.size() - 1; i >= watermark; --i) {
                TrailEntry entry = (TrailEntry)this.trail.get(i);
                entry.var.unbind();
                this.trail.remove(i);
            }
        }
        return ok;
    }

    public boolean unify(Node n1, Node n2) {
        Node dn1 = this.getGroundVersion(n1);
        Node dn2 = this.getGroundVersion(n2);
        if (dn1 instanceof Node_RuleVariable) {
            this.bind(dn1, dn2);
            return true;
        }
        if (dn2 instanceof Node_RuleVariable) {
            this.bind(dn2, dn1);
            return true;
        }
        return dn1.sameValueAs(dn2);
    }

    public boolean unifyObj(Node n1, Node n2) {
        Node dn1 = this.getGroundVersion(n1);
        Node dn2 = this.getGroundVersion(n2);
        if (dn1 instanceof Node_RuleVariable) {
            this.bind(dn1, dn2);
            return true;
        }
        if (dn2 instanceof Node_RuleVariable) {
            this.bind(dn2, dn1);
            return true;
        }
        if (Functor.isFunctor(dn1)) {
            if (Functor.isFunctor(dn2)) {
                Node[] args2;
                Functor f1 = (Functor)dn1.getLiteralValue();
                Functor f2 = (Functor)dn2.getLiteral().getValue();
                if (!f1.getName().equals(f2.getName())) {
                    return false;
                }
                Node[] args1 = f1.getArgs();
                if (args1.length != (args2 = f2.getArgs()).length) {
                    return false;
                }
                for (int i = 0; i < args1.length; ++i) {
                    if (this.unify(args1[i], args2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return dn1.sameValueAs(dn2);
    }

    public Node getGroundVersion(Node node) {
        if (node instanceof Node_RuleVariable) {
            return ((Node_RuleVariable)node).deref();
        }
        return node;
    }

    public Node getMostGroundVersion(Node node) {
        if (node instanceof Node_RuleVariable) {
            node = ((Node_RuleVariable)node).deref();
        }
        if (Functor.isFunctor(node)) {
            Functor f = (Functor)node.getLiteralValue();
            Node[] args = f.getArgs();
            Node[] cargs = new Node[args.length];
            for (int i = 0; i < args.length; ++i) {
                cargs[i] = this.getGroundVersion(args[i]);
            }
            return Functor.makeFunctorNode(f.getName(), cargs);
        }
        return node;
    }

    public Functor getMostGroundVersion(Functor f) {
        Node[] args = f.getArgs();
        Node[] cargs = new Node[args.length];
        for (int i = 0; i < args.length; ++i) {
            cargs[i] = this.getGroundVersion(args[i]);
        }
        return new Functor(f.getName(), cargs);
    }

    public boolean bind(Node var, Node value) {
        if (var == Node_RuleVariable.WILD || value == Node_RuleVariable.WILD) {
            return true;
        }
        Node dvar = this.getGroundVersion(var);
        if (dvar instanceof Node_RuleVariable) {
            this.trail.add(new TrailEntry((Node_RuleVariable)dvar, value));
            ((Node_RuleVariable)dvar).simpleBind(value);
            return true;
        }
        return dvar.sameValueAs(value);
    }

    public TriplePattern partInstantiate(TriplePattern goal) {
        return new TriplePattern(this.getMostGroundVersion(goal.getSubject()), this.getMostGroundVersion(goal.getPredicate()), this.getMostGroundVersion(goal.getObject()));
    }

    public Triple instantiate(TriplePattern goal) {
        return new Triple(this.getMostGroundVersion(goal.getSubject()), this.getMostGroundVersion(goal.getPredicate()), this.getMostGroundVersion(goal.getObject()));
    }

    static class TrailEntry {
        protected Node_RuleVariable var;
        protected Node value;

        TrailEntry(Node_RuleVariable var, Node value) {
            this.var = var;
            this.value = value;
        }
    }
}

