/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.transitiveReasoner;

import java.util.HashSet;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.FinderUtil;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

public class TransitiveEngine {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder data;
    protected boolean isPrepared = false;
    protected static HashSet subClassAliases;
    protected static HashSet subPropertyAliases;
    private static final int NOT_RELEVANT = 1;
    private static final int SUBCLASS = 2;
    private static final int SUBPROPERTY = 4;
    private static final int UPDATE_MASK = 7;
    private static final int REBUILD_SUBCLASS = 8;
    private static final int REBUILD_SUBPROPERTY = 16;
    public static Node directSubPropertyOf;
    public static Node directSubClassOf;
    public static Node subPropertyOf;
    public static Node subClassOf;

    public TransitiveEngine(TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache) {
        this.subClassCache = subClassCache;
        this.subPropertyCache = subPropertyCache;
    }

    public TransitiveEngine(TransitiveEngine tengine) {
        this.subClassCache = tengine.getSubClassCache().deepCopy();
        this.subPropertyCache = tengine.getSubPropertyCache().deepCopy();
    }

    public Finder insert(Finder baseData, FGraph newData) {
        Graph newDataG = newData.getGraph();
        this.data = baseData != null ? FinderUtil.cascade(baseData, newData) : newData;
        if (TransitiveEngine.checkOccuranceUtility(subPropertyOf, newDataG, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(subClassOf, newDataG, this.subPropertyCache)) {
            this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
            this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
        }
        return this.data;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public void setCaching(boolean cacheSP, boolean cacheSC) {
        this.subPropertyCache.setCaching(cacheSP);
        this.subClassCache.setCaching(cacheSC);
    }

    private void prepare() {
        if (this.isPrepared) {
            return;
        }
        subClassAliases = new HashSet();
        subClassAliases.add(subClassOf);
        subClassAliases.add(directSubClassOf);
        subPropertyAliases = new HashSet();
        subPropertyAliases.add(subPropertyOf);
        subPropertyAliases.add(directSubPropertyOf);
        ExtendedIterator subProps = this.subPropertyCache.find(new TriplePattern(null, subPropertyOf, subPropertyOf));
        while (subProps.hasNext()) {
            Triple spT = (Triple)subProps.next();
            Node spAlias = spT.getSubject();
            subPropertyAliases.add(spAlias);
            ExtendedIterator subClasses = this.subPropertyCache.find(new TriplePattern(null, spAlias, subClassOf));
            while (subClasses.hasNext()) {
                subClassAliases.add(((Triple)subClasses.next()).getObject());
            }
        }
        this.isPrepared = true;
    }

    private int triage(Triple t) {
        Node predicate;
        if (!this.isPrepared) {
            this.prepare();
        }
        if (subClassAliases.contains(predicate = t.getPredicate())) {
            return 2;
        }
        if (subPropertyAliases.contains(predicate)) {
            Node target = t.getObject();
            if (subClassAliases.contains(target)) {
                return 12;
            }
            if (subPropertyAliases.contains(target)) {
                return 24;
            }
            return 4;
        }
        return 1;
    }

    public Finder getFinder(TriplePattern pattern, Finder continuation) {
        Node predicate;
        if (!this.isPrepared) {
            this.prepare();
        }
        if ((predicate = pattern.getPredicate()).isVariable()) {
            return FinderUtil.cascade(this.subPropertyCache, this.subClassCache, continuation);
        }
        if (subPropertyAliases.contains(predicate)) {
            return this.subPropertyCache;
        }
        if (subClassAliases.contains(predicate)) {
            return this.subClassCache;
        }
        return continuation;
    }

    public synchronized boolean add(Triple t) {
        int triageClass = this.triage(t);
        switch (triageClass & 7) {
            case 2: {
                this.subClassCache.addRelation(t);
                break;
            }
            case 4: {
                this.subPropertyCache.addRelation(t);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((triageClass & 0x10) != 0) {
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((triageClass & 8) != 0) {
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public synchronized boolean delete(Triple t) {
        int triageClass = this.triage(t);
        switch (triageClass & 7) {
            case 2: {
                this.subClassCache.removeRelation(t);
                break;
            }
            case 4: {
                this.subPropertyCache.removeRelation(t);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((triageClass & 0x10) != 0) {
            this.subPropertyCache.clear();
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((triageClass & 8) != 0) {
            this.subClassCache.clear();
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public boolean checkOccurance(Node prop, Graph graph) {
        return TransitiveEngine.checkOccuranceUtility(prop, graph, this.subPropertyCache);
    }

    public static boolean cacheSubClassUtility(Finder graph, TransitiveGraphCache spCache, TransitiveGraphCache scCache) {
        if (graph == null) {
            return false;
        }
        scCache.cacheAll(graph, TransitiveReasoner.subClassOf);
        boolean foundAny = false;
        ExtendedIterator subClasses = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subClassOf));
        while (subClasses.hasNext()) {
            foundAny = true;
            Triple t = (Triple)subClasses.next();
            Node subClass = t.getSubject();
            if (subClass.equals(TransitiveReasoner.subClassOf)) continue;
            scCache.cacheAll(graph, subClass);
        }
        return foundAny;
    }

    public static boolean checkOccuranceUtility(Node prop, Graph graph, TransitiveGraphCache spCache) {
        boolean foundOne = false;
        ExtendedIterator uses = graph.find(null, prop, null);
        foundOne = uses.hasNext();
        uses.close();
        if (foundOne) {
            return foundOne;
        }
        ExtendedIterator propVariants = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, prop));
        while (propVariants.hasNext() && !foundOne) {
            Triple t = (Triple)propVariants.next();
            Node propVariant = t.getSubject();
            uses = graph.find(null, propVariant, null);
            foundOne = uses.hasNext();
            uses.close();
        }
        propVariants.close();
        return foundOne;
    }

    public static boolean cacheSubPropUtility(Finder graph, TransitiveGraphCache spCache) {
        if (graph == null) {
            return false;
        }
        spCache.cacheAll(graph, TransitiveReasoner.subPropertyOf);
        boolean foundAny = false;
        boolean foundMore = false;
        HashSet<Node> cached = new HashSet<Node>();
        do {
            ExtendedIterator subProps = spCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subPropertyOf));
            while (subProps.hasNext()) {
                foundMore = false;
                Triple t = (Triple)subProps.next();
                Node subProp = t.getSubject();
                if (subProp.equals(TransitiveReasoner.subPropertyOf) || cached.contains(subProp)) continue;
                foundAny = true;
                cached.add(subProp);
                spCache.cacheAll(graph, subProp);
                foundMore = true;
            }
        } while (foundMore);
        return foundAny;
    }

    static {
        directSubPropertyOf = TransitiveReasoner.directSubPropertyOf;
        directSubClassOf = TransitiveReasoner.directSubClassOf;
        subPropertyOf = RDFS.subPropertyOf.asNode();
        subClassOf = RDFS.subClassOf.asNode();
    }
}

