/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.transitiveReasoner;

import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.FinderUtil;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;

public class TransitiveInfGraph
extends BaseInfGraph {
    protected TransitiveEngine transitiveEngine;
    protected Finder tbox = null;
    protected Finder dataFind;

    public TransitiveInfGraph(Graph data, TransitiveReasoner reasoner) {
        super(data, reasoner);
    }

    public void prepare() {
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.transitiveEngine = new TransitiveEngine(((TransitiveReasoner)this.reasoner).getSubClassCache(), ((TransitiveReasoner)this.reasoner).getSubPropertyCache());
        this.dataFind = this.transitiveEngine.insert(this.tbox, this.fdata);
        this.transitiveEngine.setCaching(true, true);
        this.isPrepared = true;
    }

    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("Transitive reasoner got into an illegal state");
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        Finder cascade = this.transitiveEngine.getFinder(pattern, FinderUtil.cascade(this.tbox, continuation));
        return new UniqueExtendedIterator(cascade.find(pattern));
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, this.fdata);
    }

    public synchronized void performAdd(Triple t) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(t);
        this.transitiveEngine.add(t);
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        if (this.isPrepared) {
            this.transitiveEngine.delete(t);
        }
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

