/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.reasoner.transitiveReasoner;

import mx.com.hp.hpl.jena.graph.Capabilities;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.IllegalParameterException;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerException;
import mx.com.hp.hpl.jena.reasoner.ReasonerFactory;
import mx.com.hp.hpl.jena.reasoner.ReasonerRegistry;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveInfGraph;
import mx.com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class TransitiveReasoner
implements Reasoner {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder tbox = null;
    public static final Node directSubPropertyOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subPropertyOf);
    public static final Node directSubClassOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subClassOf);
    public static final Node subPropertyOf = RDFS.Nodes.subPropertyOf;
    public static final Node subClassOf = RDFS.Nodes.subClassOf;
    protected Capabilities capabilities;

    public TransitiveReasoner() {
        this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
    }

    protected TransitiveReasoner(Finder tbox, TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache) {
        this.tbox = tbox;
        this.subClassCache = subClassCache;
        this.subPropertyCache = subPropertyCache;
    }

    public Model getReasonerCapabilities() {
        return TransitiveReasonerFactory.theInstance().getCapabilities();
    }

    public void addDescription(Model configSpec, Resource base) {
    }

    public boolean supportsProperty(Property property) {
        ReasonerFactory rf = TransitiveReasonerFactory.theInstance();
        Model caps = rf.getCapabilities();
        Resource root = caps.getResource(rf.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox));
    }

    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox.getGraph()));
    }

    Reasoner bindSchema(Finder tbox) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        TransitiveGraphCache sCc = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache sPc = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(tbox, sPc);
        TransitiveEngine.cacheSubClassUtility(tbox, sPc, sCc);
        return new TransitiveReasoner(tbox, sCc, sPc);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        return new TransitiveInfGraph(data, this);
    }

    public void setDerivationLogging(boolean logOn) {
    }

    public void setParameter(Property parameter, Object value) {
        throw new IllegalParameterException(parameter.toString());
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public Finder getTbox() {
        return this.tbox;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

