/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.regression;

import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.rdf.model.Alt;
import mx.com.hp.hpl.jena.rdf.model.Bag;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Seq;
import mx.com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class NewRegressionContainers
extends ModelTestBase {
    protected Model m;

    public NewRegressionContainers(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionContainers.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void testCreateAnonBag() {
        Bag tv = this.m.createBag();
        NewRegressionContainers.assertTrue((boolean)tv.isAnon());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Bag));
    }

    public void testCreateNamedBag() {
        String uri = "http://aldabaran/foo";
        Bag tv = this.m.createBag(uri);
        NewRegressionContainers.assertEquals((String)uri, (String)tv.getURI());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Bag));
    }

    public void testCreateAnonAlt() {
        Alt tv = this.m.createAlt();
        NewRegressionContainers.assertTrue((boolean)tv.isAnon());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Alt));
    }

    public void testCreateNamedAlt() {
        String uri = "http://aldabaran/sirius";
        Alt tv = this.m.createAlt(uri);
        NewRegressionContainers.assertEquals((String)uri, (String)tv.getURI());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Alt));
    }

    public void testCreateAnonSeq() {
        Seq tv = this.m.createSeq();
        NewRegressionContainers.assertTrue((boolean)tv.isAnon());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Seq));
    }

    public void testCreateNamedSeq() {
        String uri = "http://aldabaran/andromeda";
        Seq tv = this.m.createSeq(uri);
        NewRegressionContainers.assertEquals((String)uri, (String)tv.getURI());
        NewRegressionContainers.assertTrue((boolean)this.m.contains((Resource)tv, RDF.type, RDF.Seq));
    }
}

