/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.regression;

import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import mx.com.hp.hpl.jena.regression.Regression;
import mx.com.hp.hpl.jena.shared.InvalidPropertyURIException;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class NewRegressionResources
extends ModelTestBase {
    public NewRegressionResources(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionResources.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void testCreateAnonResource() {
        Model m = this.getModel();
        Resource r = m.createResource();
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertNull((Object)r.getURI());
        NewRegressionResources.assertNull((Object)r.getNameSpace());
        NewRegressionResources.assertNull((Object)r.getLocalName());
    }

    public void testCreateAnonResourceWithNull() {
        Model m = this.getModel();
        Resource r = m.createResource((String)null);
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertNull((Object)r.getURI());
        NewRegressionResources.assertNull((Object)r.getNameSpace());
        NewRegressionResources.assertNull((Object)r.getLocalName());
    }

    public void testCreateNamedResource() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        NewRegressionResources.assertEquals((String)uri, (String)m.createResource(uri).getURI());
    }

    public void testCreateTypedAnonResource() {
        Model m = this.getModel();
        Resource r = m.createResource(RDF.Property);
        NewRegressionResources.assertTrue((boolean)r.isAnon());
        NewRegressionResources.assertTrue((boolean)m.contains(r, RDF.type, RDF.Property));
    }

    public void testCreateTypedNamedresource() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        Resource r = m.createResource(uri, RDF.Property);
        NewRegressionResources.assertEquals((String)uri, (String)r.getURI());
        NewRegressionResources.assertTrue((boolean)m.contains(r, RDF.type, RDF.Property));
    }

    public void testCreateAnonByFactory() {
        Model m = this.getModel();
        NewRegressionResources.assertTrue((boolean)m.createResource(new Regression.ResTestObjF()).isAnon());
    }

    public void testCreateResourceByFactory() {
        Model m = this.getModel();
        String uri = "http://aldabaran.hpl.hp.com/foo";
        NewRegressionResources.assertEquals((String)uri, (String)m.createResource(uri, new Regression.ResTestObjF()).getURI());
    }

    public void testCreateNullPropertyFails() {
        Model m = this.getModel();
        try {
            m.createProperty(null);
            NewRegressionResources.fail((String)"should not create null property");
        }
        catch (InvalidPropertyURIException e) {
            NewRegressionResources.pass();
        }
    }

    public void testCreatePropertyOneArg() {
        Model m = this.getModel();
        Property p = m.createProperty("abc/def");
        NewRegressionResources.assertEquals((String)"abc/", (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"def", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)"abc/def", (String)p.getURI());
    }

    public void testCreatePropertyTwoArgs() {
        Model m = this.getModel();
        Property p = m.createProperty("abc/", "def");
        NewRegressionResources.assertEquals((String)"abc/", (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"def", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)"abc/def", (String)p.getURI());
    }

    public void testCreatePropertyStrangeURI() {
        Model m = this.getModel();
        String uri = RDF.getURI() + "_345";
        Property p = m.createProperty(uri);
        NewRegressionResources.assertEquals((String)RDF.getURI(), (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)"_345", (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)uri, (String)p.getURI());
    }

    public void testCreatePropertyStrangeURITwoArgs() {
        Model m = this.getModel();
        String local = "_345";
        Property p = m.createProperty(RDF.getURI(), local);
        NewRegressionResources.assertEquals((String)RDF.getURI(), (String)p.getNameSpace());
        NewRegressionResources.assertEquals((String)local, (String)p.getLocalName());
        NewRegressionResources.assertEquals((String)(RDF.getURI() + local), (String)p.getURI());
    }
}

