/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.regression;

import java.util.Random;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.regression.DiHyperCube;
import mx.com.hp.hpl.jena.regression.GetModel;
import mx.com.hp.hpl.jena.regression.HyperCube;

public class testMatch {
    static int QUANTITY = 1;
    static int DIMENSION = 6;
    private String test;
    private Random random;
    private int n = 0;
    private Model m1;
    private Model m2;
    private GetModel gm1;
    private GetModel gm2;
    private boolean inError = false;

    protected static void doTest(GetModel gm1) {
        new testMatch(4011, gm1).test();
        System.out.println("End testMatch");
    }

    testMatch(int seed, GetModel gm) {
        this.test = "testMatch seed=" + seed;
        this.random = new Random(seed);
        this.gm1 = gm;
        this.gm2 = gm;
    }

    void test() {
        this.test2HyperCube(DIMENSION, QUANTITY);
        this.test4DiHyperCube(DIMENSION, QUANTITY, true);
        this.test4DiHyperCube(DIMENSION, QUANTITY, false);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, true);
        this.test4ToggleHyperCube(DIMENSION, QUANTITY, false);
        if (QUANTITY > 5) {
            this.test2DiHyperCube(DIMENSION, QUANTITY, true);
            this.test2DiHyperCube(DIMENSION, QUANTITY, false);
            this.test4HyperCube(DIMENSION, QUANTITY, true);
            this.test4HyperCube(DIMENSION, QUANTITY, false);
        }
    }

    private void test2DiHyperCube(int dim, int cnt, boolean type) {
        try {
            int sz = 1 << dim;
            for (int i = 0; i < cnt; ++i) {
                int b1;
                int a1;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                while (type != DiHyperCube.equal(a1 = this.random.nextInt(sz), b1 = this.random.nextInt(sz))) {
                }
                ++this.n;
                new DiHyperCube(dim, this.m1).dupe(a1).dupe(a1).dupe(a1);
                ++this.n;
                new DiHyperCube(dim, this.m2).dupe(b1).dupe(b1).dupe(b1);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == type) continue;
                this.error();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void test4DiHyperCube(int dim, int cnt, boolean type) {
        try {
            int sz = 1 << dim;
            for (int i = 0; i < cnt; ++i) {
                int b2;
                int b1;
                int a2;
                int a1;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    a1 = this.random.nextInt(sz);
                    b1 = this.random.nextInt(sz);
                } while (type != DiHyperCube.equal(a1, a2 = this.random.nextInt(sz), b1, b2 = this.random.nextInt(sz)));
                ++this.n;
                new DiHyperCube(dim, this.m1).dupe(a1).dupe(a1).dupe(a1).dupe(a2).dupe(a2).dupe(a2);
                ++this.n;
                new DiHyperCube(dim, this.m2).dupe(b1).dupe(b1).dupe(b1).dupe(b2).dupe(b2).dupe(b2);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == type) continue;
                System.out.println("(" + a1 + "," + a2 + "),(" + b1 + "," + b2 + ")");
                this.error();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void test2HyperCube(int dim, int cnt) {
        try {
            int sz = 1 << dim;
            for (int i = 0; i < cnt; ++i) {
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                int a1 = this.random.nextInt(sz);
                int b1 = this.random.nextInt(sz);
                ++this.n;
                new HyperCube(dim, this.m1).dupe(a1).dupe(a1).dupe(a1);
                ++this.n;
                new HyperCube(dim, this.m2).dupe(b1).dupe(b1).dupe(b1);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2)) continue;
                this.error();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void test4HyperCube(int dim, int cnt, boolean type) {
        try {
            int sz = 1 << dim;
            for (int i = 0; i < cnt; ++i) {
                int b2;
                int b1;
                int a2;
                int a1;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    a1 = this.random.nextInt(sz);
                    b1 = this.random.nextInt(sz);
                } while (type != HyperCube.equal(a1, a2 = this.random.nextInt(sz), b1, b2 = this.random.nextInt(sz)));
                ++this.n;
                new HyperCube(dim, this.m1).dupe(a1).dupe(a1).dupe(a1).dupe(a2).dupe(a2).dupe(a2);
                ++this.n;
                new HyperCube(dim, this.m2).dupe(b1).dupe(b1).dupe(b1).dupe(b2).dupe(b2).dupe(b2);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == type) continue;
                System.out.println("(" + a1 + "," + a2 + "),(" + b1 + "," + b2 + ")");
                this.error();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void test4ToggleHyperCube(int dim, int cnt, boolean type) {
        try {
            int sz = 1 << dim;
            for (int i = 0; i < cnt; ++i) {
                int b2;
                int b1;
                int a2;
                int a1;
                ++this.n;
                this.m1 = this.gm1.get();
                ++this.n;
                this.m2 = this.gm2.get();
                do {
                    a1 = this.random.nextInt(sz);
                    b1 = this.random.nextInt(sz);
                } while (type != HyperCube.equal(a1, a2 = this.random.nextInt(sz), b1, b2 = this.random.nextInt(sz)));
                ++this.n;
                new HyperCube(dim, this.m1).toggle(a1, a2);
                ++this.n;
                new HyperCube(dim, this.m2).toggle(b1, b2);
                ++this.n;
                if (this.m1.isIsomorphicWith(this.m2) == type) continue;
                System.out.println("(" + a1 + "," + a2 + "),(" + b1 + "," + b2 + ")");
                this.error();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void error() {
        System.out.println(this.test + ": failed test " + Integer.toString(this.n));
        this.inError = true;
    }

    public void error(Exception e) {
        System.out.println("Test Failed: " + this.test + " " + this.n + " " + e.toString());
        this.inError = true;
        e.printStackTrace();
    }

    public boolean getErrors() {
        return this.inError;
    }
}

