/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.regression;

import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.regression.GetModel;
import mx.com.hp.hpl.jena.regression.ResourceReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testModelEquals {
    protected static Log logger = LogFactory.getLog((Class)testModelEquals.class);
    private boolean inError = false;

    void test(GetModel gm) {
        String test = "testModelEquals";
        String filebase = "testing/regression/" + test + "/";
        boolean[] results = new boolean[]{false, true, true, true, true, false, false, true, false};
        int n = 0;
        try {
            Model m2;
            Model m1;
            for (n = 1; n < 7; ++n) {
                m1 = gm.get();
                m2 = gm.get();
                m1.read(ResourceReader.getInputStream(filebase + Integer.toString(n) + "-1.rdf"), "http://www.example.org/");
                m2.read(ResourceReader.getInputStream(filebase + Integer.toString(n) + "-2.rdf"), "http://www.example.org/");
                if (m1.isIsomorphicWith(m2) == results[n]) continue;
                this.error(test, n);
                System.out.println("m1:");
                m1.write(System.out, "N-TRIPLE");
                System.out.println("m2:");
                m2.write(System.out, "N-TRIPLE");
            }
            for (n = 7; n < 9; ++n) {
                m1 = gm.get();
                m2 = gm.get();
                m1.read(ResourceReader.getInputStream(filebase + Integer.toString(n) + "-1.nt"), "", "N-TRIPLE");
                m2.read(ResourceReader.getInputStream(filebase + Integer.toString(n) + "-2.nt"), "", "N-TRIPLE");
                if (m1.isIsomorphicWith(m2) == results[n]) continue;
                this.error(test, n);
                System.out.println("m1:");
                m1.write(System.out, "N-TRIPLE");
                System.out.println("m2:");
                m2.write(System.out, "N-TRIPLE");
            }
        }
        catch (Exception e) {
            this.inError = true;
            logger.error((Object)(" test " + test + "[" + n + "]"), (Throwable)e);
        }
    }

    protected void error(String test, int n) {
        System.out.println(test + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

