/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.regression;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import mx.com.hp.hpl.jena.rdf.arp.JenaReader;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFReader;
import mx.com.hp.hpl.jena.rdf.model.impl.NTripleReader;
import mx.com.hp.hpl.jena.regression.ResourceReader;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.NoReaderForLangException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testReaderInterface {
    protected static Log logger = LogFactory.getLog((Class)testReaderInterface.class);
    private boolean inError = false;

    protected static void doTest(Model m1) {
        new testReaderInterface().test(m1);
    }

    void test(Model m1) {
        String test = "testReaderInterface";
        String filebase = "testing/regression/" + test + "/";
        int n = 0;
        try {
            ++n;
            RDFReader reader = m1.getReader();
            ++n;
            reader = m1.getReader("N-TRIPLE");
            if (!(reader instanceof NTripleReader)) {
                this.error(test, n);
            }
            ++n;
            try {
                m1.setReaderClassName("foobar", "");
                reader = m1.getReader("foobar");
                this.error(test, n);
            }
            catch (NoReaderForLangException jx) {
                // empty catch block
            }
            ++n;
            m1.setReaderClassName("foobar", JenaReader.class.getName());
            reader = m1.getReader("foobar");
            if (!(reader instanceof JenaReader)) {
                this.error(test, n);
            }
            try {
                ++n;
                m1.read("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdf-containers-syntax-vs-schema/test001.rdf");
                ++n;
                m1.read("http://www.w3.org/2000/10/rdf-tests/rdfcore/rdf-containers-syntax-vs-schema/test001.nt", "N-TRIPLE");
            }
            catch (JenaException jx) {
                if (jx.getCause() instanceof NoRouteToHostException || jx.getCause() instanceof UnknownHostException || jx.getCause() instanceof ConnectException || jx.getCause() instanceof IOException) {
                    logger.warn((Object)"Cannot access public internet - part of test not executed");
                }
                throw jx;
            }
            ++n;
            m1.read(ResourceReader.getInputStream(filebase + "1.rdf"), "http://example.org/");
            ++n;
            m1.read(ResourceReader.getInputStream(filebase + "2.nt"), "", "N-TRIPLE");
        }
        catch (Exception e) {
            this.inError = true;
            logger.error((Object)(" test " + test + "[" + n + "]"), (Throwable)e);
        }
    }

    protected void error(String test, int n) {
        System.out.println(test + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

