/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.shared;

import java.util.Map;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import mx.com.hp.hpl.jena.vocabulary.DC;
import mx.com.hp.hpl.jena.vocabulary.JenaModelSpec;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.RSS;
import mx.com.hp.hpl.jena.vocabulary.VCARD;

public interface PrefixMapping {
    public static final PrefixMapping Standard = Factory.create().setNsPrefix("rdfs", RDFS.getURI()).setNsPrefix("rdf", RDF.getURI()).setNsPrefix("dc", DC.getURI()).setNsPrefix("daml", "http://www.daml.org/2001/03/daml+oil#").setNsPrefix("owl", OWL.getURI()).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#").lock();
    public static final PrefixMapping Extended = Factory.create().setNsPrefixes(Standard).setNsPrefix("rss", RSS.getURI()).setNsPrefix("vcard", VCARD.getURI()).setNsPrefix("jms", JenaModelSpec.getURI()).setNsPrefix("eg", "http://www.example.org/").lock();

    public PrefixMapping setNsPrefix(String var1, String var2);

    public PrefixMapping removeNsPrefix(String var1);

    public PrefixMapping setNsPrefixes(PrefixMapping var1);

    public PrefixMapping setNsPrefixes(Map var1);

    public PrefixMapping withDefaultMappings(PrefixMapping var1);

    public String getNsPrefixURI(String var1);

    public String getNsURIPrefix(String var1);

    public Map getNsPrefixMap();

    public String expandPrefix(String var1);

    public String shortForm(String var1);

    public String usePrefix(String var1);

    public String qnameFor(String var1);

    public PrefixMapping lock();

    public boolean samePrefixMappingAs(PrefixMapping var1);

    public static class Factory {
        public static PrefixMapping create() {
            return new PrefixMappingImpl();
        }
    }

    public static class JenaLockedException
    extends JenaException {
        public JenaLockedException(PrefixMapping pm) {
            super(pm.toString());
        }
    }

    public static class IllegalPrefixException
    extends JenaException {
        public IllegalPrefixException(String prefixName) {
            super(prefixName);
        }
    }
}

