/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.shared.uuid;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import mx.com.hp.hpl.jena.shared.uuid.UUID;

class UUID_V1
extends UUID {
    static final int versionHere = 1;
    static final int variantHere = 2;
    long timestamp;
    static long gregorianTime = 0L;
    static final long UUIDS_PER_TICK = 100L;
    static long uuids_this_tick = 101L;
    static String address = null;
    private static Object mutex = new Object();
    private static long lastTime = 0L;
    private static long DELAY = 10L;
    static boolean initialized = false;
    private static boolean noRandWarningSent = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UUID_V1() {
        super(1, 2);
        UUID_V1.init();
        Object object = mutex;
        synchronized (object) {
            if (uuids_this_tick >= 100L) {
                UUID_V1.setTime();
            }
            this.timestamp = gregorianTime + uuids_this_tick;
            ++uuids_this_tick;
        }
        this.generateString();
    }

    UUID_V1(String s) throws UUID.FormatException {
        super(1, 2);
        if (s.equals("00000000-0000-0000-0000-000000000000")) {
            this.uuid = "00000000-0000-0000-0000-000000000000";
            return;
        }
        if ((s = s.toLowerCase()).startsWith("urn:")) {
            s = s.substring(4);
        }
        if (s.startsWith("uuid:")) {
            s = s.substring(5);
        }
        if (s.length() != 36) {
            throw new UUID.FormatException("UUID string is not 36 chars long: it's " + s.length() + " [" + s + "]");
        }
        if (s.charAt(8) != '-' && s.charAt(13) != '-' && s.charAt(18) != '-' && s.charAt(23) != '-') {
            throw new UUID.FormatException("String does not have dashes in the right places: " + s);
        }
        String timeLow = this.extract(s, 0, 8);
        String timeMid = this.extract(s, 9, 13);
        String verStr = this.extract(s, 14, 15);
        String timeHigh = this.extract(s, 15, 18);
        String clockSeqHighRes = this.extract(s, 19, 21);
        String clockSeqLow = this.extract(s, 21, 23);
        String address = this.extract(s, 24, 36);
        try {
            int var = Integer.parseInt(clockSeqHighRes.substring(0, 1), 16);
            if ((var >>= 2) != 2) {
                throw new UUID.FormatException("UUID variant is not 2: " + var + " in " + s);
            }
            int ver = Integer.parseInt(verStr, 16);
            if (ver != 1) {
                throw new UUID.FormatException("UUID version is strange: " + ver + " in " + s);
            }
        }
        catch (NumberFormatException e) {
            throw new UUID.FormatException("UUID has unknown variant or version: " + s);
        }
        this.uuid = timeLow + "-" + timeMid + "-" + this.version + timeHigh + "-" + clockSeqHighRes + clockSeqLow + "-" + address;
        if (!s.equals(this.uuid)) {
            System.out.println("Input2:  " + s);
            System.out.println("Output: " + this.uuid);
            throw new UUID.FormatException("UUID string did not regenerate: " + s);
        }
    }

    public boolean equals(UUID u) {
        return this.uuid.equals(u.uuid);
    }

    public static void init() {
        if (!initialized) {
            UUID_V1.reset();
            initialized = true;
        }
    }

    public static void uninit() {
        initialized = false;
    }

    public static void reset() {
        UUID_V1.setNetworkId();
        UUID_V1.setTime();
    }

    private void generateString() {
        String gt = Long.toHexString(this.timestamp);
        while (gt.length() < 15) {
            gt = "0" + gt;
        }
        if (gt.length() != 15) {
            throw new RuntimeException("UUID error: Gregorian time is not 15 hex digits long");
        }
        int len = 15;
        String timeLow = gt.substring(7);
        String timeMid = gt.substring(3, 7);
        String timeHigh = gt.substring(0, 3);
        String versionStr = Integer.toString(this.version);
        String clockSeqHighRes = Integer.toHexString(128);
        String clockSeqLow = "00";
        this.uuid = timeLow + "-" + timeMid + "-" + versionStr + timeHigh + "-" + clockSeqHighRes + clockSeqLow + "-" + address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTime() {
        long time = 0L;
        Object object = mutex;
        synchronized (object) {
            if (lastTime == 0L) {
                lastTime = System.currentTimeMillis();
            }
            boolean done = false;
            while (!done) {
                time = System.currentTimeMillis();
                if (time < lastTime + DELAY) {
                    try {
                        Thread.sleep(DELAY);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                done = true;
            }
        }
        lastTime = time;
        uuids_this_tick = 0L;
        gregorianTime = time * 10L + 122192928000000000L;
    }

    private static void setNetworkId() {
        Random random;
        byte[] seed;
        block8: {
            seed = UUID_V1.makeSeed();
            random = null;
            if (useSecureRandom) {
                try {
                    SecureRandom sRandom = SecureRandom.getInstance("SHA1PRNG");
                    sRandom.setSeed(seed);
                    random = sRandom;
                }
                catch (NoSuchAlgorithmException ex) {
                    if (noRandWarningSent) break block8;
                    System.err.println("No secure random generator.");
                    noRandWarningSent = true;
                }
            }
        }
        byte[] b = new byte[6];
        if (random == null) {
            int i;
            for (i = 0; i < Math.min(seed.length, b.length); ++i) {
                b[i] = seed[i];
            }
            while (i < b.length) {
                b[i] = 0;
                ++i;
            }
        } else {
            random.nextBytes(b);
        }
        b[0] = (byte)(b[0] | 0x80);
        address = UUID.stringify(b);
        address = "000000000000" + address;
        address = address.substring(address.length() - 12);
        String nibble = address.substring(0, 1);
        int i = Integer.parseInt(nibble, 16);
        if ((i & 8) == 0) {
            System.err.println("High bit of address is not one: " + address);
            address = Integer.toHexString(i) + address.substring(1);
        }
    }
}

