/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.shared.wg;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;
import mx.com.hp.hpl.jena.iri.IRIFactory;
import mx.com.hp.hpl.jena.iri.RDFURIReference;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.shared.wg.LazyInputStream;
import mx.com.hp.hpl.jena.shared.wg.LazyURLInputStream;
import mx.com.hp.hpl.jena.shared.wg.LazyZipEntryInputStream;

public class TestInputStreamFactory {
    final IRIFactory iriFactory = new IRIFactory();
    private final RDFURIReference base;
    private final RDFURIReference mapBase;
    private final ZipFile zip;
    private final String property;
    private String createMe = "error";

    public TestInputStreamFactory(RDFURIReference baseDir, RDFURIReference getBaseDir) {
        this.base = baseDir;
        this.mapBase = getBaseDir;
        this.zip = null;
        this.property = null;
    }

    public TestInputStreamFactory(RDFURIReference baseDir, ZipFile zip) {
        this.base = baseDir;
        this.mapBase = null;
        this.zip = zip;
        this.property = null;
    }

    public TestInputStreamFactory(RDFURIReference baseDir, String propDir) {
        this.createMe = "new TestInputStreamFactory(URI.create(\"" + ((Object)baseDir).toString() + "\"),\"" + propDir + "\")";
        this.base = baseDir;
        this.mapBase = null;
        this.zip = null;
        this.property = propDir.endsWith("/") ? propDir : propDir + "/";
    }

    public RDFURIReference getBase() {
        return this.base;
    }

    public InputStream open(String str) {
        return this.open(this.iriFactory.create(str));
    }

    public InputStream fullyOpen(String str) throws IOException {
        InputStream in = this.open(this.iriFactory.create(str));
        if (in instanceof LazyInputStream && !((LazyInputStream)in).connect()) {
            return null;
        }
        return in;
    }

    public InputStream open(RDFURIReference uri) {
        return (InputStream)this.open(uri, true);
    }

    public boolean savable() {
        return this.mapBase != null && this.mapBase.getScheme().equalsIgnoreCase("file");
    }

    public OutputStream openOutput(String str) {
        OutputStream foo = (OutputStream)this.open(this.iriFactory.create(str), false);
        return foo;
    }

    public String getCreationJava() {
        return this.createMe;
    }

    private Object open(RDFURIReference uri, boolean in) {
        RDFURIReference relative;
        RDFURIReference rDFURIReference = relative = uri.isAbsolute() ? this.base.relativize(uri, 8) : uri;
        if (relative.isAbsolute()) {
            throw new IllegalArgumentException("This  TestInputStreamFactory only knows about '" + this.base + "'.");
        }
        String relPath = ((Object)relative).toString();
        if (relPath.length() - relPath.lastIndexOf(46) > 5) {
            relPath = relPath + ".rdf";
            relative = this.iriFactory.create(relPath);
        }
        if (this.mapBase != null) {
            try {
                URL url = this.mapBase.resolve(relative).toURL();
                if (!in) {
                    if (url.getProtocol().equalsIgnoreCase("file")) {
                        return new FileOutputStream(url.getFile());
                    }
                    throw new IllegalArgumentException("Can only save to file: scheme");
                }
                return new LazyURLInputStream(url);
            }
            catch (MalformedURLException e) {
                throw new JenaException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JenaException(e);
            }
        }
        if (!in) {
            throw new IllegalArgumentException("Can only save to URLs");
        }
        if (this.zip != null) {
            return new LazyZipEntryInputStream(this.zip, relPath);
        }
        return TestInputStreamFactory.getInputStream(this.property + relPath);
    }

    private static InputStream getInputStream(String prop) {
        ClassLoader loader = TestInputStreamFactory.class.getClassLoader();
        if (loader == null) {
            throw new SecurityException("Cannot access class loader");
        }
        InputStream in = loader.getResourceAsStream("testing/" + prop);
        if (in == null) {
            try {
                in = new FileInputStream("testing/" + prop);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in == null) {
                throw new IllegalArgumentException("Resource: " + prop + " not found on class path.");
            }
        }
        return in;
    }

    public RDFURIReference getMapBase() {
        return this.mapBase;
    }
}

