/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.util.FileUtils;
import mx.com.hp.hpl.jena.util.Locator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorFile
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorFile.class);
    private String altDir = null;
    private String altDirLogStr = "";

    public LocatorFile(String dir) {
        if (dir != null) {
            if (dir.endsWith("/") || dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.altDirLogStr = " [" + dir + "]";
        }
        this.altDir = dir;
    }

    LocatorFile() {
        this(null);
    }

    private File toFile(String filenameOrURI) {
        String fn = FileUtils.toFilename(filenameOrURI);
        if (fn == null) {
            return null;
        }
        if (this.altDir != null && !fn.startsWith("/") && !fn.startsWith(FileManager.filePathSeparator)) {
            fn = this.altDir + File.separator + fn;
        }
        return new File(fn);
    }

    public boolean exists(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        if (f == null) {
            return false;
        }
        return f.exists();
    }

    public InputStream open(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        if (f == null || !f.exists()) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + filenameOrURI + this.altDirLogStr));
            }
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(f);
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("LocatorFile: Failed to open: " + filenameOrURI + this.altDirLogStr));
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Found: " + filenameOrURI + this.altDirLogStr));
            }
            return in;
        }
        catch (IOException ioEx) {
            log.warn((Object)("File unreadable (but exists): " + f.getPath() + " Exception: " + ioEx.getMessage()));
            return null;
        }
    }

    public String getName() {
        String tmp = "LocatorFile";
        if (this.altDir != null) {
            tmp = tmp + "(" + this.altDir + ")";
        }
        return tmp;
    }
}

