/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util;

import java.io.PrintWriter;
import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_ANY;
import mx.com.hp.hpl.jena.graph.Node_Literal;
import mx.com.hp.hpl.jena.graph.Node_URI;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.vocabulary.DAML_OIL;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class PrintUtil {
    protected static PrefixMapping prefixMapping = PrefixMapping.Factory.create();
    public static final String egNS = "urn:x-hp:eg/";

    public static void init() {
        PrintUtil.registerPrefix("rdf", RDF.getURI());
        PrintUtil.registerPrefix("rdfs", RDFS.getURI());
        PrintUtil.registerPrefix("drdfs", "urn:x-hp-direct-predicate:http_//www.w3.org/2000/01/rdf-schema#");
        PrintUtil.registerPrefix("owl", OWL.getURI());
        PrintUtil.registerPrefix("daml", DAML_OIL.NAMESPACE_DAML.getURI());
        PrintUtil.registerPrefix("jr", ReasonerVocabulary.getJenaReasonerNS());
        PrintUtil.registerPrefix("rb", ReasonerVocabulary.getRBNamespace());
        PrintUtil.registerPrefix("eg", egNS);
        PrintUtil.registerPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    public static void registerPrefix(String prefix, String namespace) {
        prefixMapping.setNsPrefix(prefix, namespace);
    }

    public static String print(Node node) {
        if (node instanceof Node_URI) {
            return node.toString(prefixMapping);
        }
        if (node instanceof Node_Literal) {
            String lf = node.getLiteralLexicalForm();
            return "'" + lf + "'" + (node.getLiteralDatatype() == null ? "" : "^^" + node.getLiteralDatatypeURI());
        }
        if (node instanceof Node_ANY) {
            return "*";
        }
        if (node == null) {
            return "null";
        }
        return node.toString();
    }

    public static String print(RDFNode node) {
        if (node == null) {
            return "null";
        }
        return PrintUtil.print(node.asNode());
    }

    public static String print(Triple triple) {
        if (triple == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triple.getSubject()) + " " + PrintUtil.print(triple.getPredicate()) + " " + PrintUtil.print(triple.getObject()) + ")";
    }

    public static String print(TriplePattern triple) {
        if (triple == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triple.getSubject()) + " " + PrintUtil.print(triple.getPredicate()) + " " + PrintUtil.print(triple.getObject()) + ")";
    }

    public static String print(Statement stmt) {
        if (stmt == null) {
            return "(null)";
        }
        return PrintUtil.print(stmt.asTriple());
    }

    public static String print(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Triple) {
            return PrintUtil.print((Triple)obj);
        }
        if (obj instanceof TriplePattern) {
            return PrintUtil.print((TriplePattern)obj);
        }
        if (obj instanceof Node) {
            return PrintUtil.print((Node)obj);
        }
        if (obj instanceof RDFNode) {
            return PrintUtil.print((RDFNode)obj);
        }
        if (obj instanceof Statement) {
            return PrintUtil.print((Statement)obj);
        }
        return obj.toString();
    }

    public static String expandQname(String uri) {
        return prefixMapping.expandPrefix(uri);
    }

    public static void printIndent(PrintWriter out, int indent) {
        StringBuffer spaces = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            spaces.append(" ");
        }
        out.print(spaces.toString());
    }

    public static void printOut(Iterator it) {
        while (it.hasNext()) {
            System.out.println("   " + PrintUtil.print(it.next()));
        }
    }

    static {
        PrintUtil.init();
    }
}

