/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util;

import mx.com.hp.hpl.jena.graph.Factory;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;

public class QueryMapper {
    private Query query;
    private Node[] variables;
    private Graph graph;
    static final String varPrefix = "jqv:";

    public QueryMapper(Model m, Resource[] variables) {
        this.graph = this.toQueryGraph(m);
        this.query = new Query(this.graph);
        this.variables = this.toQueryVariables(variables);
    }

    public Node[] getVariables() {
        return this.variables;
    }

    public Query getQuery() {
        return this.query;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph toQueryGraph(Model m) {
        StmtIterator st = m.listStatements();
        Graph result = Factory.createDefaultGraph();
        while (st.hasNext()) {
            result.add(this.toQueryTriple(st.nextStatement()));
        }
        return result;
    }

    public Triple toQueryTriple(Statement s) {
        return Triple.create(this.toQueryNode(s.getSubject()), this.toQueryNode(s.getPredicate()), this.toQueryNode(s.getObject()));
    }

    public Node[] toQueryVariables(Resource[] vars) {
        Node[] result = new Node[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            result[i] = this.toQueryNode(vars[i]);
        }
        return result;
    }

    public Node toQueryNode(RDFNode rn) {
        Node n = rn.asNode();
        return n.isURI() && n.getURI().startsWith(varPrefix) ? Node.createVariable(n.getURI().substring(varPrefix.length())) : n;
    }
}

