/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util.cache;

import mx.com.hp.hpl.jena.enhanced.EnhNode;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.util.cache.Cache;

public class EnhancedNodeCache
implements Cache {
    protected String name;
    protected EnhNode[] elements;
    protected boolean enabled = true;
    protected long gets;
    protected long puts;
    protected long hits;

    public EnhancedNodeCache(String name, int size) {
        this.name = name;
        this.elements = new EnhNode[size];
    }

    public Object get(Object key) {
        if (this.enabled) {
            ++this.gets;
            Node n = (Node)key;
            int i = this.hashNode(n);
            EnhNode result = this.elements[i];
            if (result != null && result.asNode().equals(key)) {
                ++this.hits;
                return result;
            }
        }
        return null;
    }

    public void put(Object key, Object value) {
        if (this.enabled) {
            ++this.puts;
            Node n = (Node)key;
            int i = this.hashNode(n);
            this.elements[i] = (EnhNode)value;
        }
    }

    protected int hashNode(Node n) {
        return (n.hashCode() & Integer.MAX_VALUE) % this.elements.length;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enabled) {
        boolean result = this.enabled;
        this.enabled = enabled;
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = null;
        }
    }

    public long getGets() {
        return this.gets;
    }

    public long getPuts() {
        return this.puts;
    }

    public long getHits() {
        return this.hits;
    }
}

