/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.util.iterator.Filter;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class FilterIterator
extends WrappedIterator {
    protected final Filter f;
    protected Object current;
    protected boolean canRemove;
    protected boolean hasCurrent;

    public FilterIterator(Filter fl, Iterator e) {
        super(e);
        this.f = fl;
    }

    public synchronized boolean hasNext() {
        while (!this.hasCurrent && super.hasNext()) {
            this.current = super.next();
            this.hasCurrent = this.accept(this.current);
        }
        this.canRemove = false;
        return this.hasCurrent;
    }

    protected boolean accept(Object x) {
        return this.f.accept(x);
    }

    public synchronized void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("FilterIterators do not permit calls to hasNext between calls to next and remove.");
        }
        super.remove();
    }

    public synchronized Object next() {
        if (this.hasCurrent || this.hasNext()) {
            this.canRemove = true;
            this.hasCurrent = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }
}

