/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util.iterator;

import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.MapFilter;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

public class MapFilterIterator
extends NiceIterator
implements ExtendedIterator {
    MapFilter f;
    Object current;
    boolean dead;
    ClosableIterator underlying;

    public MapFilterIterator(MapFilter fl, ExtendedIterator e) {
        this.f = fl;
        this.current = null;
        this.dead = false;
        this.underlying = e;
    }

    public synchronized boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        while (this.underlying.hasNext()) {
            this.current = this.f.accept(this.underlying.next());
            if (this.current == null) continue;
            return true;
        }
        this.current = null;
        this.dead = true;
        return false;
    }

    public void close() {
        this.underlying.close();
    }

    public synchronized void remove() {
        if (this.current != null || this.dead) {
            throw new IllegalStateException("FilterIterator does not permit calls to hasNext between calls to next and remove.");
        }
        this.underlying.remove();
    }

    public synchronized Object next() {
        if (this.hasNext()) {
            Object r = this.current;
            this.current = null;
            return r;
        }
        throw new NoSuchElementException();
    }
}

