/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util.iterator;

import java.util.Iterator;
import java.util.Random;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class RandomOrderIterator
extends WrappedIterator {
    private Random rnd = new Random();
    private Object[] buffer;
    int top;

    public RandomOrderIterator(int sz, Iterator base) {
        super(base);
        this.buffer = new Object[sz];
        this.top = 0;
        this.fill();
    }

    public boolean hasNext() {
        return this.top > 0;
    }

    public Object next() {
        int ix = this.rnd.nextInt(this.top);
        Object rslt = this.buffer[ix];
        --this.top;
        this.buffer[ix] = this.buffer[this.top];
        this.fill();
        return rslt;
    }

    public void remove() {
        throw new UnsupportedOperationException("randomizing does not allow modification");
    }

    private void fill() {
        while (this.top < this.buffer.length && super.hasNext()) {
            this.buffer[this.top++] = super.next();
        }
    }
}

