/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.util.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.util.xml.SimpleXMLPath;
import org.w3c.dom.Node;

public class SimpleXMLPathIterator
implements Iterator {
    protected List m_stack;
    protected SimpleXMLPath m_path;
    protected boolean m_prepared = false;
    protected Object m_result;
    protected int m_len;

    public SimpleXMLPathIterator(SimpleXMLPath path, Node node) {
        this.m_path = path;
        this.m_len = path.getPathComponents().size();
        this.m_stack = new ArrayList(this.m_len);
        this.m_stack.add(path.getPathComponent(0).getAll(node));
        this.prepare();
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from SimpleXMLPathIterator");
    }

    public boolean hasNext() {
        this.prepare();
        return this.m_result != null;
    }

    public Object next() {
        this.prepare();
        if (this.m_result == null) {
            throw new NoSuchElementException("No more values on this SimpleXMLPath");
        }
        this.m_prepared = false;
        return this.m_result;
    }

    protected void prepare() {
        if (!this.m_prepared) {
            this.evaluate();
            this.m_prepared = true;
        }
    }

    protected void evaluate() {
        int i;
        this.m_result = null;
        for (i = 0; i < this.min(this.m_len, this.m_stack.size()) && this.m_stack.get(i) != null; ++i) {
        }
        --i;
        while (i >= 0 && i < this.min(this.m_len, this.m_stack.size())) {
            Iterator j = (Iterator)this.m_stack.get(i);
            if (j == null) {
                --i;
                continue;
            }
            if (!j.hasNext()) {
                this.m_stack.add(i, null);
                this.m_result = null;
                --i;
                continue;
            }
            this.m_result = j.next();
            if (++i >= this.m_len) continue;
            this.m_stack.add(i, this.m_path.getPathComponent(i).getAll((Node)this.m_result));
        }
    }

    private int min(int x, int y) {
        return x < y ? x : y;
    }
}

