/*
 * Decompiled with CFR 0.152.
 */
package mx.jena;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.util.FileUtils;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.jena.cmdline.ArgDecl;
import mx.jena.cmdline.ArgHandler;
import mx.jena.cmdline.CommandLine;

public class rdfcat {
    public final ArgDecl IN_N3 = new ArgDecl(false, "n", "n3", "ttl", "N3", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.expectInput("N3");
        }
    });
    public final ArgDecl IN_RDF_XML = new ArgDecl(false, "x", "xml", "rdfxml", "rdf", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.expectInput("RDF/XML");
        }
    });
    public final ArgDecl IN_NTRIPLE = new ArgDecl(false, "t", "ntriples", "ntriple", "n-triple", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.expectInput("N-TRIPLE");
        }
    });
    public final ArgDecl OUT_LANG = new ArgDecl(true, "out", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setOutput(val);
        }
    });
    public final ArgDecl INCLUDE = new ArgDecl(false, "include", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setInclude(true);
        }
    });
    public final ArgDecl NOINCLUDE = new ArgDecl(false, "noinclude", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setInclude(false);
        }
    });
    public final ArgDecl HELP = new ArgDecl(false, "help", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.usage();
        }
    });
    public final ArgDecl USAGE = new ArgDecl(false, "usage", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.usage();
        }
    });
    protected CommandLine m_cmdLine = new RCCommandLine().add(this.IN_N3).add(this.IN_NTRIPLE).add(this.IN_RDF_XML).add(this.OUT_LANG).add(this.INCLUDE).add(this.NOINCLUDE).add(this.HELP).add(this.USAGE);
    protected Model m_model = ModelFactory.createDefaultModel();
    protected String m_outputFormat = "RDF/XML-ABBREV";
    protected String m_inputFormat = "RDF/XML";
    protected boolean m_include = false;
    protected Set m_seen = new HashSet();

    public static void main(String[] args) {
        new rdfcat().go(args);
    }

    protected void go(String[] args) {
        this.m_cmdLine.process(args);
        this.m_model.write(this.getOutputStream(), this.m_outputFormat);
    }

    protected void expectInput(String lang) {
        this.m_inputFormat = lang;
    }

    protected void setOutput(String lang) {
        if ("RDF/XML".equalsIgnoreCase(lang) || "x".equalsIgnoreCase(lang) || "xml".equalsIgnoreCase(lang) || "rdf".equalsIgnoreCase(lang) || "rdfxml".equalsIgnoreCase(lang)) {
            this.m_outputFormat = "RDF/XML";
        } else if ("RDF/XML-ABBREV".equalsIgnoreCase(lang) || "abbrev".equalsIgnoreCase(lang)) {
            this.m_outputFormat = "RDF/XML-ABBREV";
        } else if ("N3".equalsIgnoreCase(lang) || "n".equalsIgnoreCase(lang) || "ttl".equalsIgnoreCase(lang)) {
            this.m_outputFormat = "N3";
        } else if ("N-TRIPLE".equalsIgnoreCase(lang) || "ntriples".equalsIgnoreCase(lang) || "ntriple".equalsIgnoreCase(lang) || "t".equalsIgnoreCase(lang)) {
            this.m_outputFormat = "N-TRIPLE";
        } else {
            throw new IllegalArgumentException(lang + " is not recognised as a legal output format");
        }
    }

    protected void setInclude(boolean incl) {
        this.m_include = incl;
    }

    protected void readInput(String inputName) {
        ArrayList<String> queue = new ArrayList<String>();
        queue.add(inputName);
        while (!queue.isEmpty()) {
            String in = (String)queue.remove(0);
            if (this.m_seen.contains(in)) continue;
            this.m_seen.add(in);
            Model inModel = ModelFactory.createDefaultModel();
            if (inputName.equals("-")) {
                inModel.read(System.in, null, this.m_inputFormat);
            } else {
                String lang = FileUtils.guessLang(inputName, this.m_inputFormat);
                FileManager.get().readModel(inModel, inputName, lang);
            }
            if (this.m_include) {
                this.addIncludes(inModel, queue);
            }
            this.m_model.add(inModel);
            this.m_model.setNsPrefixes(inModel);
        }
    }

    protected OutputStream getOutputStream() {
        return System.out;
    }

    protected void addIncludes(Model inModel, List queue) {
        StmtIterator i = inModel.listStatements(null, RDFS.seeAlso, (RDFNode)null);
        while (i.hasNext()) {
            RDFNode n = i.nextStatement().getObject();
            queue.add(n.isLiteral() ? ((Literal)n).getLexicalForm() : ((Resource)n).getURI());
        }
        i = inModel.listStatements(null, OWL.imports, (RDFNode)null);
        while (i.hasNext()) {
            queue.add(i.nextStatement().getResource());
        }
    }

    protected void usage() {
        System.err.println("Usage: java jena.rdfcat (option|input)*");
        System.err.println("Concatenates the contents of zero or more input RDF documents.");
        System.err.println("Options: -out N3 | N-TRIPLE | RDF/XML | RDF/XML-ABBREV");
        System.err.println("         -n  expect subsequent inputs in N3 syntax");
        System.err.println("         -x  expect subsequent inputs in RDF/XML syntax");
        System.err.println("         -t  expect subsequent inputs in N-TRIPLE syntax");
        System.err.println("         -[no]include  include rdfs:seeAlso and owl;imports");
        System.err.println("input can be filename, URL, or - for stdin");
        System.err.println("Recognised aliases for -n are: -n3 -ttl or -N3");
        System.err.println("Recognised aliases for -x are: -xml -rdf or -rdfxml");
        System.err.println("Recognised aliases for -t are: -ntriple");
        System.err.println("Output format aliases: x, xml or rdf for RDF/XML, n, n3 or ttl for N3, t or ntriple for N-TRIPLE");
        System.exit(0);
    }

    protected class RCCommandLine
    extends CommandLine {
        protected RCCommandLine() {
        }

        public boolean endProcessing(String argStr) {
            return false;
        }

        public void handleUnrecognizedArg(String argStr) {
            if (argStr.equals("-") || !argStr.startsWith("-")) {
                rdfcat.this.readInput(argStr);
            } else {
                System.err.println("Unrecognised argument: " + argStr);
                rdfcat.this.usage();
            }
        }
    }
}

