/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import uk.ac.shef.wit.simmetrics.metrichandlers.MetricHandler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestMetrics {
    private static final int TESTTIMINGMILLISECONDSPERTEST = 200;
    private static final int TESTMAXLENGTHTIMINGTEST = 3000;
    private static final int TESTMAXLENGTHTIMINGSTEPSIZE = 50;
    private static final int TESTMAXLENGTHTIMINGTERMLENGTH = 10;
    private static final String string1 = "Sam J Chapman";
    private static final String string2 = "Samuel Chapman";
    private static final String string3 = "S Chapman";
    private static final String string4 = "Samuel John Chapman";
    private static final String string5 = "John Smith";
    private static final String string6 = "Richard Smith";
    private static final String string7 = "aaaa mnop zzzz";
    private static final String string8 = "bbbb mnop yyyy";
    private static final String string9 = "aa mnop zzzzzz";
    private static final String string10 = "a";
    private static final String string11 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
    private static final String string12 = "aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz";
    private static final String string13 = "jjjjj bcdefgh qqqqqqqq stuvwx yyyyyy";
    private static final String string14 = "aaaaa bcdefgh stuvwx zzzzzz";
    private static final String string15 = "aaaaa aaaaa aaaaa zzzzzz";
    private static final String string16 = "aaaaa aaaaa";
    private static final String[][] testCases = new String[][]{{"Sam J Chapman", "Samuel Chapman"}, {"Sam J Chapman", "S Chapman"}, {"Samuel Chapman", "S Chapman"}, {"Sam J Chapman", "Sam J Chapman"}, {"Samuel John Chapman", "John Smith"}, {"John Smith", "Richard Smith"}, {"John Smith", "Sam J Chapman"}, {"Sam J Chapman", "Richard Smith"}, {"Sam J Chapman", "Samuel John Chapman"}, {"Samuel Chapman", "Samuel John Chapman"}, {"aaaa mnop zzzz", "bbbb mnop yyyy"}, {"aaaa mnop zzzz", "aa mnop zzzzzz"}, {"bbbb mnop yyyy", "aa mnop zzzzzz"}, {"a", "a"}, {"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}, {"a", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}, {"aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz", "jjjjj bcdefgh qqqqqqqq stuvwx yyyyyy"}, {"aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz", "aaaaa bcdefgh stuvwx zzzzzz"}, {"aaaaa bcdefgh stuvwx zzzzzz", "aaaaa aaaaa aaaaa zzzzzz"}, {"aaaaa aaaaa", "aaaaa aaaaa"}};

    public static void main(String[] args) {
        ArrayList<String> metricStrings = MetricHandler.GetMetricsAvailable();
        ArrayList<AbstractStringMetric> testMetricArrayList = new ArrayList<AbstractStringMetric>();
        for (String metricString : metricStrings) {
            testMetricArrayList.add(MetricHandler.createMetric(metricString));
        }
        TestMetrics.testMethod(testMetricArrayList, args);
    }

    private static void Usage() {
        System.out.println("Usage: testMethod \"String1 to Test\" \"String2 to test\"");
        System.out.println("or");
        System.out.println("Usage: testMethod \"timing");
        System.out.println("AS NO INPUT - running defualt test cases\n");
    }

    private static void testMethod(ArrayList<AbstractStringMetric> metricVector, String[] args) {
        int i;
        boolean useCmdArgs = false;
        boolean testTimingComplexity = false;
        if (args.length == 1) {
            testTimingComplexity = true;
        } else if (args.length == 2) {
            useCmdArgs = true;
        } else {
            TestMetrics.Usage();
        }
        System.out.println("Performing Tests with Following Metrics:");
        for (i = 0; i < metricVector.size(); ++i) {
            System.out.println("m" + (i + 1) + " " + metricVector.get(i).getShortDescriptionString());
        }
        System.out.println();
        if (!useCmdArgs) {
            System.out.println("Using the Following Test Cases:");
            for (i = 0; i < testCases.length; ++i) {
                System.out.println("t" + (i + 1) + " \"" + testCases[i][0] + "\" vs \"" + testCases[i][1] + "\"");
            }
            System.out.println();
        } else {
            System.out.println("Using the Input Test Case:");
            System.out.println("t1 \"" + args[0] + "\" vs \"" + args[1] + "\"");
            System.out.println();
        }
        System.out.print("  \t");
        if (!useCmdArgs) {
            for (int j = 0; j < testCases.length; ++j) {
                if (j < 9) {
                    System.out.print("t" + (j + 1) + "=\t (t" + (j + 1) + "ms)\t");
                    continue;
                }
                System.out.print("t" + (j + 1) + "= (t" + (j + 1) + "ms)");
            }
        } else {
            System.out.print("t1");
        }
        System.out.print("\n");
        DecimalFormat df = new DecimalFormat("0.00");
        int metricTests = 0;
        long totalTime = System.currentTimeMillis();
        for (int i2 = 0; i2 < metricVector.size(); ++i2) {
            AbstractStringMetric metric = metricVector.get(i2);
            System.out.print("m" + (i2 + 1) + "\t");
            if (testTimingComplexity) {
                StringBuffer testString = new StringBuffer();
                int termLen = 0;
                int len = 1;
                while (len < 3000) {
                    if (termLen < 10) {
                        testString.append((char)(97 + (int)(Math.random() * 25.0)));
                    } else {
                        testString.append(' ');
                        termLen = 0;
                    }
                    ++len;
                    ++termLen;
                }
                for (len = 1; len < 3000; len += 50) {
                    long timeTaken = 0L;
                    int iterations = 0;
                    String input1 = testString.substring(0, len);
                    while (timeTaken < 200L) {
                        timeTaken += metric.getSimilarityTimingActual(input1, input1);
                        ++iterations;
                        ++metricTests;
                    }
                    System.out.print(df.format((float)timeTaken / (float)iterations) + "\t");
                }
            } else if (!useCmdArgs) {
                for (String[] testCase : testCases) {
                    float result = metric.getSimilarity(testCase[0], testCase[1]);
                    ++metricTests;
                    long timeTaken = 0L;
                    int iterations = 0;
                    while (timeTaken < 200L) {
                        timeTaken += metric.getSimilarityTimingActual(testCase[0], testCase[1]);
                        ++iterations;
                        ++metricTests;
                    }
                    System.out.print(df.format(result) + " (" + df.format((float)timeTaken / (float)iterations) + ")\t");
                }
            } else {
                float result = metric.getSimilarity(args[0], args[1]);
                ++metricTests;
                long timeTaken = 0L;
                int iterations = 0;
                while (timeTaken < 250L) {
                    timeTaken += metric.getSimilarityTimingActual(args[0], args[1]);
                    ++iterations;
                    ++metricTests;
                }
                System.out.print(df.format(result) + " (" + df.format((float)timeTaken / (float)iterations) + ")\t");
            }
            System.out.print("\t(" + metric.getShortDescriptionString() + ") - testsSoFar = " + metricTests + "\n");
        }
        totalTime = System.currentTimeMillis() - totalTime;
        System.out.println("\nTotal Metrics Tests = " + metricTests + " in " + totalTime + "ms\t\t meaning " + df.format((float)metricTests / (float)totalTime) + " tests per millisecond");
    }
}

