/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.math.MathFuncs;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AbstractAffineGapCost;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AbstractSubstitutionCost;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AffineGap5_1;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.SubCost5_3_Minus3;

public class SmithWatermanGotohWindowedAffine
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 4.5E-5f;
    private final int windowSize;
    private AbstractSubstitutionCost dCostFunc;
    private AbstractAffineGapCost gGapFunc;

    public SmithWatermanGotohWindowedAffine() {
        this.gGapFunc = new AffineGap5_1();
        this.dCostFunc = new SubCost5_3_Minus3();
        this.windowSize = 100;
    }

    public SmithWatermanGotohWindowedAffine(AbstractAffineGapCost gapCostFunc) {
        this.gGapFunc = gapCostFunc;
        this.dCostFunc = new SubCost5_3_Minus3();
        this.windowSize = 100;
    }

    public SmithWatermanGotohWindowedAffine(AbstractAffineGapCost gapCostFunc, AbstractSubstitutionCost costFunc) {
        this.gGapFunc = gapCostFunc;
        this.dCostFunc = costFunc;
        this.windowSize = 100;
    }

    public SmithWatermanGotohWindowedAffine(AbstractSubstitutionCost costFunc) {
        this.gGapFunc = new AffineGap5_1();
        this.dCostFunc = costFunc;
        this.windowSize = 100;
    }

    public SmithWatermanGotohWindowedAffine(int affineGapWindowSize) {
        this.gGapFunc = new AffineGap5_1();
        this.dCostFunc = new SubCost5_3_Minus3();
        this.windowSize = affineGapWindowSize;
    }

    public SmithWatermanGotohWindowedAffine(AbstractAffineGapCost gapCostFunc, int affineGapWindowSize) {
        this.gGapFunc = gapCostFunc;
        this.dCostFunc = new SubCost5_3_Minus3();
        this.windowSize = affineGapWindowSize;
    }

    public SmithWatermanGotohWindowedAffine(AbstractAffineGapCost gapCostFunc, AbstractSubstitutionCost costFunc, int affineGapWindowSize) {
        this.gGapFunc = gapCostFunc;
        this.dCostFunc = costFunc;
        this.windowSize = affineGapWindowSize;
    }

    public SmithWatermanGotohWindowedAffine(AbstractSubstitutionCost costFunc, int affineGapWindowSize) {
        this.gGapFunc = new AffineGap5_1();
        this.dCostFunc = costFunc;
        this.windowSize = affineGapWindowSize;
    }

    public final AbstractAffineGapCost getgGapFunc() {
        return this.gGapFunc;
    }

    public final void setgGapFunc(AbstractAffineGapCost gGapFunc) {
        this.gGapFunc = gGapFunc;
    }

    public final AbstractSubstitutionCost getdCostFunc() {
        return this.dCostFunc;
    }

    public final void setdCostFunc(AbstractSubstitutionCost dCostFunc) {
        this.dCostFunc = dCostFunc;
    }

    public String getShortDescriptionString() {
        return "SmithWatermanGotohWindowedAffine";
    }

    public String getLongDescriptionString() {
        return "Implements the Smith-Waterman-Gotoh algorithm with a windowed affine gap providing a similarity measure between two string";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return (str1Length * str2Length * (float)this.windowSize + str1Length * str2Length * (float)this.windowSize) * 4.5E-5f;
    }

    public final float getSimilarity(String string1, String string2) {
        float smithWatermanGotoh = this.getUnNormalisedSimilarity(string1, string2);
        float maxValue = Math.min(string1.length(), string2.length());
        maxValue = this.dCostFunc.getMaxCost() > -this.gGapFunc.getMaxCost() ? (maxValue *= this.dCostFunc.getMaxCost()) : (maxValue *= -this.gGapFunc.getMaxCost());
        if (maxValue == 0.0f) {
            return 1.0f;
        }
        return smithWatermanGotoh / maxValue;
    }

    public float getUnNormalisedSimilarity(String s, String t) {
        int j;
        int k;
        int windowStart;
        float maxGapCost;
        float cost;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n][m];
        float maxSoFar = 0.0f;
        for (i = 0; i < n; ++i) {
            cost = this.dCostFunc.getCost(s, i, t, 0);
            if (i == 0) {
                d[0][0] = Math.max(0.0f, cost);
            } else {
                maxGapCost = 0.0f;
                windowStart = i - this.windowSize;
                if (windowStart < 1) {
                    windowStart = 1;
                }
                for (k = windowStart; k < i; ++k) {
                    maxGapCost = Math.max(maxGapCost, d[i - k][0] - this.gGapFunc.getCost(s, i - k, i));
                }
                d[i][0] = MathFuncs.max3(0.0f, maxGapCost, cost);
            }
            if (!(d[i][0] > maxSoFar)) continue;
            maxSoFar = d[i][0];
        }
        for (j = 0; j < m; ++j) {
            cost = this.dCostFunc.getCost(s, 0, t, j);
            if (j == 0) {
                d[0][0] = Math.max(0.0f, cost);
            } else {
                maxGapCost = 0.0f;
                windowStart = j - this.windowSize;
                if (windowStart < 1) {
                    windowStart = 1;
                }
                for (k = windowStart; k < j; ++k) {
                    maxGapCost = Math.max(maxGapCost, d[0][j - k] - this.gGapFunc.getCost(t, j - k, j));
                }
                d[0][j] = MathFuncs.max3(0.0f, maxGapCost, cost);
            }
            if (!(d[0][j] > maxSoFar)) continue;
            maxSoFar = d[0][j];
        }
        for (i = 1; i < n; ++i) {
            for (j = 1; j < m; ++j) {
                int k2;
                cost = this.dCostFunc.getCost(s, i, t, j);
                float maxGapCost1 = 0.0f;
                float maxGapCost2 = 0.0f;
                int windowStart2 = i - this.windowSize;
                if (windowStart2 < 1) {
                    windowStart2 = 1;
                }
                for (k2 = windowStart2; k2 < i; ++k2) {
                    maxGapCost1 = Math.max(maxGapCost1, d[i - k2][j] - this.gGapFunc.getCost(s, i - k2, i));
                }
                windowStart2 = j - this.windowSize;
                if (windowStart2 < 1) {
                    windowStart2 = 1;
                }
                for (k2 = windowStart2; k2 < j; ++k2) {
                    maxGapCost2 = Math.max(maxGapCost2, d[i][j - k2] - this.gGapFunc.getCost(t, j - k2, j));
                }
                d[i][j] = MathFuncs.max4(0.0f, maxGapCost1, maxGapCost2, d[i - 1][j - 1] + cost);
                if (!(d[i][j] > maxSoFar)) continue;
                maxSoFar = d[i][j];
            }
        }
        return maxSoFar;
    }
}

