/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model.helper;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyObject;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.helper.OWLClassAxiomVisitorAdapter;
import org.semanticweb.owl.model.helper.OWLEntityFinder;
import org.semanticweb.owl.model.helper.OWLObjectsUsedCollector;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;

public class OntologyHelper {
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$model$helper$OntologyHelper == null ? (class$org$semanticweb$owl$model$helper$OntologyHelper = OntologyHelper.class$("org.semanticweb.owl.model.helper.OntologyHelper")) : class$org$semanticweb$owl$model$helper$OntologyHelper));
    static /* synthetic */ Class class$org$semanticweb$owl$model$helper$OntologyHelper;

    public static Set importClosure(OWLOntology ontology) throws OWLException {
        HashSet<OWLOntology> result = new HashSet<OWLOntology>();
        result.add(ontology);
        OntologyHelper.addImportsTo(ontology, result);
        return result;
    }

    private static void addImportsTo(OWLOntology ontology, Set set) throws OWLException {
        Set imported = ontology.getIncludedOntologies();
        Iterator it = imported.iterator();
        while (it.hasNext()) {
            OWLOntology importee = (OWLOntology)it.next();
            if (set.contains(importee)) continue;
            set.add(importee);
            OntologyHelper.addImportsTo(importee, set);
        }
    }

    public static OWLClass getClassNamed(OWLOntology ontology, URI uri) throws OWLException {
        return ontology.getClass(uri);
    }

    public static OWLClass getClassNamedFromImportsClosure(OWLOntology ontology, URI uri) throws OWLException {
        Set ontologies = OntologyHelper.importClosure(ontology);
        Iterator it = ontologies.iterator();
        while (it.hasNext()) {
            OWLClass clazz = ((OWLOntology)it.next()).getClass(uri);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static OWLIndividual getIndividualNamed(OWLOntology ontology, URI uri) throws OWLException {
        Iterator it = ontology.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual ind = (OWLIndividual)it.next();
            if (ind.isAnonymous() || !ind.getURI().equals(uri)) continue;
            return ind;
        }
        return null;
    }

    public static OWLObjectProperty getObjectPropertyNamed(OWLOntology ontology, URI uri) throws OWLException {
        Iterator it = ontology.getObjectProperties().iterator();
        while (it.hasNext()) {
            OWLObjectProperty prop = (OWLObjectProperty)it.next();
            if (!prop.getURI().equals(uri)) continue;
            return prop;
        }
        return null;
    }

    public static OWLDataProperty getDataPropertyNamed(OWLOntology ontology, URI uri) throws OWLException {
        Iterator it = ontology.getDataProperties().iterator();
        while (it.hasNext()) {
            OWLDataProperty prop = (OWLDataProperty)it.next();
            if (!prop.getURI().equals(uri)) continue;
            return prop;
        }
        return null;
    }

    public static Set allURIs(OWLOntology ontology) throws OWLException {
        OWLObject entity;
        HashSet<URI> allURIs = new HashSet<URI>();
        Iterator cit = ontology.getClasses().iterator();
        while (cit.hasNext()) {
            entity = (OWLNamedObject)cit.next();
            allURIs.add(entity.getURI());
        }
        cit = ontology.getIndividuals().iterator();
        while (cit.hasNext()) {
            entity = (OWLIndividual)cit.next();
            if (entity.isAnonymous()) continue;
            allURIs.add(entity.getURI());
        }
        cit = ontology.getObjectProperties().iterator();
        while (cit.hasNext()) {
            entity = (OWLNamedObject)cit.next();
            allURIs.add(entity.getURI());
        }
        cit = ontology.getDataProperties().iterator();
        while (cit.hasNext()) {
            entity = (OWLNamedObject)cit.next();
            allURIs.add(entity.getURI());
        }
        cit = ontology.getDatatypes().iterator();
        while (cit.hasNext()) {
            entity = (OWLDataType)cit.next();
            allURIs.add(entity.getURI());
        }
        return allURIs;
    }

    public static Set allDefinitionsAsAxioms(OWLOntology ontology) throws OWLException {
        HashSet<OWLSubClassAxiom> result = new HashSet<OWLSubClassAxiom>();
        OWLDataFactory factory = ontology.getOWLDataFactory();
        result.addAll(ontology.getClassAxioms());
        Iterator it = ontology.getClasses().iterator();
        while (it.hasNext()) {
            OWLClassAxiom ca;
            OWLClass clazz = (OWLClass)it.next();
            Iterator sit = clazz.getSuperClasses(ontology).iterator();
            while (sit.hasNext()) {
                ca = factory.getOWLSubClassAxiom(clazz, (OWLDescription)sit.next());
                result.add((OWLSubClassAxiom)ca);
            }
            HashSet<OWLClass> eqs = new HashSet<OWLClass>();
            eqs.add(clazz);
            eqs.addAll(clazz.getEquivalentClasses(ontology));
            eqs.addAll(clazz.getEnumerations(ontology));
            if (eqs.size() <= 1) continue;
            ca = factory.getOWLEquivalentClassesAxiom(eqs);
            result.add((OWLSubClassAxiom)ca);
        }
        return result;
    }

    public static Set allPropertyDefinitionsAsAxioms(OWLOntology ontology) throws OWLException {
        HashSet<OWLSubPropertyAxiom> result = new HashSet<OWLSubPropertyAxiom>();
        OWLDataFactory factory = ontology.getOWLDataFactory();
        result.addAll(ontology.getPropertyAxioms());
        Set props = ontology.getObjectProperties();
        props.addAll(ontology.getDataProperties());
        Iterator it = props.iterator();
        while (it.hasNext()) {
            OWLProperty prop = (OWLProperty)it.next();
            Iterator sit = prop.getSuperProperties(ontology).iterator();
            while (sit.hasNext()) {
                OWLSubPropertyAxiom ca = factory.getOWLSubPropertyAxiom(prop, (OWLProperty)sit.next());
                result.add(ca);
            }
        }
        return result;
    }

    public static Set allSuperProperties(OWLProperty prop, Set ontologies) throws OWLException {
        HashSet result = new HashSet();
        OntologyHelper.addAllSupers(prop, result, ontologies);
        return result;
    }

    private static void addAllSupers(OWLProperty prop, Set collectedSupers, Set ontologies) throws OWLException {
        if (collectedSupers.contains(prop)) {
            return;
        }
        collectedSupers.add(prop);
        Set newSupers = prop.getSuperProperties(ontologies);
        Iterator it = newSupers.iterator();
        while (it.hasNext()) {
            OWLProperty superP = (OWLProperty)it.next();
            OntologyHelper.addAllSupers(superP, collectedSupers, ontologies);
        }
    }

    public static List getAnnotations(OWLOntology ontology, OWLObject oo, OWLAnnotationProperty oap) throws OWLException {
        ArrayList<Object> result = new ArrayList<Object>();
        Set annos = oo.getAnnotations(ontology);
        Iterator annoIt = annos.iterator();
        while (annoIt.hasNext()) {
            OWLAnnotationInstance annInst = (OWLAnnotationInstance)annoIt.next();
            if (!annInst.getProperty().equals(oap) || !(annInst.getContent() instanceof OWLDataValue)) continue;
            result.add(((OWLDataValue)annInst.getContent()).getValue());
        }
        return result;
    }

    public static OWLOntology getOntology(URI uri) throws OWLException {
        OWLConnection connection = null;
        connection = OWLManager.getOWLConnection();
        return connection.getOntologyPhysical(uri);
    }

    public static Set getRDFLabels(OWLOntology ontology, OWLObject oo, String language) throws OWLException {
        OWLAnnotationProperty rdfLabel = null;
        try {
            rdfLabel = ontology.getOWLDataFactory().getOWLAnnotationProperty(new URI(OWLVocabularyAdapter.INSTANCE.getLabel()));
        }
        catch (URISyntaxException ex) {
            throw new OWLException("Can't create rdfs:label " + ex.getMessage());
        }
        HashSet<Object> result = new HashSet<Object>();
        Set annos = oo.getAnnotations(ontology);
        Iterator annoIt = annos.iterator();
        while (annoIt.hasNext()) {
            OWLAnnotationInstance annInst = (OWLAnnotationInstance)annoIt.next();
            if (!annInst.getProperty().equals(rdfLabel) || !(annInst.getContent() instanceof OWLDataValue)) continue;
            OWLDataValue odv = (OWLDataValue)annInst.getContent();
            String odvLang = odv.getLang();
            if (language != null && (odvLang == null || !language.equals(odvLang))) continue;
            result.add(odv.getValue());
        }
        return result;
    }

    public static Set getRDFLabels(OWLOntology ontology, OWLObject oo) throws OWLException {
        return OntologyHelper.getRDFLabels(ontology, oo, null);
    }

    public static Set allAssertedSuperClasses(OWLOntology ontology, final OWLClass cl) throws OWLException {
        final HashSet result = new HashSet();
        result.addAll(cl.getSuperClasses(ontology));
        OWLClassAxiomVisitorAdapter acav = new OWLClassAxiomVisitorAdapter(){

            public void visit(OWLSubClassAxiom ax) throws OWLException {
                if (ax.getSubClass() == cl) {
                    result.add(ax.getSuperClass());
                }
            }
        };
        Iterator it = ontology.getClassAxioms().iterator();
        while (it.hasNext()) {
            OWLClassAxiom cax = (OWLClassAxiom)it.next();
            cax.accept(acav);
        }
        return result;
    }

    public static Set allAssertedEquivalentClasses(OWLOntology ontology, final OWLClass cl) throws OWLException {
        final HashSet result = new HashSet();
        result.addAll(cl.getEquivalentClasses(ontology));
        OWLClassAxiomVisitorAdapter acav = new OWLClassAxiomVisitorAdapter(){

            public void visit(OWLEquivalentClassesAxiom ax) throws OWLException {
                boolean found = false;
                Iterator it = ax.getEquivalentClasses().iterator();
                while (it.hasNext()) {
                    if (it.next() != cl) continue;
                    found = true;
                }
                if (found) {
                    it = ax.getEquivalentClasses().iterator();
                    while (it.hasNext()) {
                        Object eq = it.next();
                        if (eq == cl) continue;
                        result.add(eq);
                    }
                }
            }
        };
        Iterator it = ontology.getClassAxioms().iterator();
        while (it.hasNext()) {
            OWLClassAxiom cax = (OWLClassAxiom)it.next();
            cax.accept(acav);
        }
        return result;
    }

    public static Set entityUsage(OWLOntology ontology, OWLEntity entity) throws OWLException {
        OWLOntologyObject axiom;
        OWLProperty prop;
        OWLObject oo;
        Iterator thingIt;
        HashSet thingsToLookIn;
        logger.debug((Object)("Looking for " + entity));
        OWLEntityFinder finder = new OWLEntityFinder(entity);
        HashSet<OWLOntologyObject> users = new HashSet<OWLOntologyObject>();
        Iterator it = ontology.getClasses().iterator();
        while (it.hasNext()) {
            OWLClass clazz = (OWLClass)it.next();
            logger.debug((Object)("Checking " + clazz));
            thingsToLookIn = new HashSet();
            thingsToLookIn.addAll(clazz.getSuperClasses(ontology));
            thingsToLookIn.addAll(clazz.getEquivalentClasses(ontology));
            thingsToLookIn.addAll(clazz.getEnumerations(ontology));
            thingsToLookIn.addAll(clazz.getAnnotations(ontology));
            thingIt = thingsToLookIn.iterator();
            while (thingIt.hasNext()) {
                finder.reset();
                oo = (OWLObject)thingIt.next();
                oo.accept(finder);
                if (!finder.found()) continue;
                logger.debug((Object)("Found in " + clazz));
                users.add(clazz);
            }
        }
        it = ontology.getObjectProperties().iterator();
        while (it.hasNext()) {
            prop = (OWLObjectProperty)it.next();
            thingsToLookIn = new HashSet();
            thingsToLookIn.addAll(prop.getDomains(ontology));
            thingsToLookIn.addAll(prop.getRanges(ontology));
            thingsToLookIn.addAll(prop.getAnnotations(ontology));
            thingIt = thingsToLookIn.iterator();
            while (thingIt.hasNext()) {
                finder.reset();
                oo = (OWLObject)thingIt.next();
                oo.accept(finder);
                if (!finder.found()) continue;
                users.add(prop);
            }
            Iterator invIt = prop.getInverses(ontology).iterator();
            while (invIt.hasNext()) {
                if (invIt.next() != entity) continue;
                users.add(prop);
            }
        }
        it = ontology.getDataProperties().iterator();
        while (it.hasNext()) {
            prop = (OWLDataProperty)it.next();
            thingsToLookIn = new HashSet();
            thingsToLookIn.addAll(prop.getDomains(ontology));
            thingsToLookIn.addAll(prop.getAnnotations(ontology));
            thingIt = thingsToLookIn.iterator();
            while (thingIt.hasNext()) {
                finder.reset();
                oo = (OWLObject)thingIt.next();
                oo.accept(finder);
                if (!finder.found()) continue;
                users.add(prop);
            }
        }
        it = ontology.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual ind = (OWLIndividual)it.next();
            logger.debug((Object)("Checking " + ind));
            thingsToLookIn = new HashSet();
            thingsToLookIn.addAll(ind.getTypes(ontology));
            thingsToLookIn.addAll(ind.getAnnotations(ontology));
            Map map = ind.getObjectPropertyValues(ontology);
            Iterator mit = map.keySet().iterator();
            while (mit.hasNext()) {
                Object k = mit.next();
                thingsToLookIn.add(k);
                thingsToLookIn.addAll((Set)map.get(k));
            }
            thingsToLookIn.addAll(ind.getDataPropertyValues(ontology).keySet());
            Iterator thingIt2 = thingsToLookIn.iterator();
            while (thingIt2.hasNext()) {
                finder.reset();
                OWLObject oo2 = (OWLObject)thingIt2.next();
                oo2.accept(finder);
                if (!finder.found()) continue;
                logger.debug((Object)("Found in " + ind));
                users.add(ind);
            }
        }
        it = ontology.getClassAxioms().iterator();
        while (it.hasNext()) {
            axiom = (OWLClassAxiom)it.next();
            finder.reset();
            axiom.accept(finder);
            if (!finder.found()) continue;
            users.add(axiom);
        }
        it = ontology.getPropertyAxioms().iterator();
        while (it.hasNext()) {
            axiom = (OWLPropertyAxiom)it.next();
            finder.reset();
            axiom.accept(finder);
            if (!finder.found()) continue;
            users.add(axiom);
        }
        return users;
    }

    public static Set objectsUsed(OWLOntology ontology, OWLEntity entity) throws OWLException {
        OWLObjectsUsedCollector oouc = new OWLObjectsUsedCollector(ontology);
        entity.accept(oouc);
        return oouc.entities();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            OWLOntology onto = OntologyHelper.getOntology(new URI(args[0]));
            if (onto != null) {
                System.out.println(onto.getClasses().size() + "\tClasses");
                System.out.println(onto.getObjectProperties().size() + "\tObject Properties");
                System.out.println(onto.getDataProperties().size() + "\tDatatype Properties");
                System.out.println(onto.getIndividuals().size() + "\tIndividuals");
            }
            Iterator it = onto.getClasses().iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                System.out.println(clazz.getURI());
                System.out.println("Usage:");
                Iterator usageIt = OntologyHelper.entityUsage(onto, clazz).iterator();
                while (usageIt.hasNext()) {
                    System.out.println("\t" + usageIt.next());
                }
                System.out.println("Uses:");
                usageIt = OntologyHelper.objectsUsed(onto, clazz).iterator();
                while (usageIt.hasNext()) {
                    System.out.println("\t" + usageIt.next());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

