/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLOntologies;
import org.semanticweb.owl.util.OntologyProcessor;

public class OntologyReplicator
extends OntologyProcessor {
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$util$OntologyReplicator == null ? (class$org$semanticweb$owl$util$OntologyReplicator = OntologyReplicator.class$("org.semanticweb.owl.util.OntologyReplicator")) : class$org$semanticweb$owl$util$OntologyReplicator));
    public static final int PHASE_LOAD_CONCEPTS = 1;
    public static final int PHASE_COPY_CONCEPTS = 2;
    public static final int PHASE_LOAD_PROPERTIES = 3;
    public static final int PHASE_COPY_PROPERTIES = 4;
    public static final int PHASE_LOAD_INSTANCES = 5;
    public static final int PHASE_COPY_INSTANCES = 6;
    protected Map m_logicalToPhysicalURIs;
    protected OWLOntology m_sourceOWLOntology;
    protected OWLOntology m_targetOWLOntology;
    protected OWLConnection m_targetOWLConnection;
    protected List m_changeEvents;
    protected Map m_sourceToTarget = new HashMap();
    static /* synthetic */ Class class$org$semanticweb$owl$util$OntologyReplicator;

    public OntologyReplicator(OWLOntology sourceOWLOntology, Map logicalToPhysicalURIs, OWLConnection targetKAONConnection) {
        this.m_logicalToPhysicalURIs = logicalToPhysicalURIs;
        this.m_sourceOWLOntology = sourceOWLOntology;
        this.m_targetOWLConnection = targetKAONConnection;
        this.m_changeEvents = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology doReplication() throws OWLException, InterruptedException {
        try {
            this.setUpModelMappings();
            this.processConcepts();
            this.processProperties();
            this.processInstances();
            OWLOntology oWLOntology = this.m_targetOWLOntology;
            Object var3_2 = null;
            this.m_logicalToPhysicalURIs = null;
            this.m_sourceOWLOntology = null;
            this.m_targetOWLOntology = null;
            this.m_targetOWLConnection = null;
            this.m_changeEvents = null;
            return oWLOntology;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_logicalToPhysicalURIs = null;
            this.m_sourceOWLOntology = null;
            this.m_targetOWLOntology = null;
            this.m_targetOWLConnection = null;
            this.m_changeEvents = null;
            throw throwable;
        }
    }

    protected void setUpModelMappings() throws OWLException, InterruptedException {
        OWLOntology sourceOWLOntology;
        this.m_targetOWLOntology = this.createTargetOWLOntology(this.m_sourceOWLOntology);
        this.m_sourceToTarget.put(this.m_sourceOWLOntology, this.m_targetOWLOntology);
        Iterator<Object> iterator = OWLOntologies.getAllIncludedOntologies(this.m_sourceOWLOntology).iterator();
        while (iterator.hasNext()) {
            sourceOWLOntology = (OWLOntology)iterator.next();
            try {
                this.m_targetOWLConnection.getOntologyLogical(sourceOWLOntology.getLogicalURI());
            }
            catch (OWLException modelShouldBeReplicated) {
                OWLOntology targetOWLOntology = this.createTargetOWLOntology(sourceOWLOntology);
                this.m_sourceToTarget.put(sourceOWLOntology, targetOWLOntology);
            }
            this.checkInterrupted();
        }
        iterator = this.m_sourceToTarget.keySet().iterator();
        while (iterator.hasNext()) {
            sourceOWLOntology = (OWLOntology)iterator.next();
            OWLOntology targetOWLOntology = (OWLOntology)this.m_sourceToTarget.get(sourceOWLOntology);
            Iterator inner = sourceOWLOntology.getIncludedOntologies().iterator();
            while (inner.hasNext()) {
                OWLOntology sourceIncludedOWLOntology = (OWLOntology)inner.next();
                OWLOntology targetIncludedOWLOntology = this.m_targetOWLConnection.getOntologyLogical(sourceIncludedOWLOntology.getLogicalURI());
                if (!targetOWLOntology.getIncludedOntologies().contains(targetIncludedOWLOntology)) {
                    logger.warn((Object)"Implement me!");
                }
                this.checkInterrupted();
            }
        }
    }

    protected OWLOntology createTargetOWLOntology(OWLOntology sourceOWLOntology) throws OWLException {
        URI logicalURI = sourceOWLOntology.getLogicalURI();
        URI targetPhysicalURI = (URI)this.m_logicalToPhysicalURIs.get(logicalURI);
        OWLOntology targetOWLOntology = this.m_targetOWLConnection.createOntology(targetPhysicalURI, logicalURI);
        return targetOWLOntology;
    }

    protected void processConcepts() throws OWLException, InterruptedException {
        Set concepts = this.loadConcepts();
        this.flushChanges();
        this.copyConcepts(concepts);
        this.flushChanges();
    }

    protected void processProperties() throws OWLException, InterruptedException {
        Set properties = this.loadProperties();
        this.flushChanges();
        this.copyProperties(properties);
        this.flushChanges();
    }

    protected void processInstances() throws OWLException, InterruptedException {
        Set instances = this.loadInstances();
        this.flushChanges();
        this.copyInstances(instances);
        this.flushChanges();
    }

    protected Set loadConcepts() throws OWLException, InterruptedException {
        logger.warn((Object)"Implement me!");
        return null;
    }

    protected Set loadProperties() throws OWLException, InterruptedException {
        logger.warn((Object)"Implement me!");
        return null;
    }

    protected Set loadInstances() throws OWLException, InterruptedException {
        logger.debug((Object)"Implement me!");
        return null;
    }

    protected void copyConcepts(Set concepts) throws OWLException, InterruptedException {
        logger.debug((Object)"Implement me!");
    }

    protected void copyProperties(Set properties) throws OWLException, InterruptedException {
        logger.warn((Object)"Implement me!");
    }

    protected void copyInstances(Set instances) throws OWLException, InterruptedException {
        logger.warn((Object)"Implement me!");
    }

    protected void applyChange(OntologyChange changeEvent) throws OWLException {
        this.m_changeEvents.add(changeEvent);
    }

    protected void flushChanges() throws OWLException {
        logger.warn((Object)"Removed Stuff! SKB");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

